package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TagImageHook} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagImageHookAssert<S extends AbstractTagImageHookAssert<S, A>, A extends TagImageHook> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagImageHookAssert}</code> to make assertions on actual TagImageHook.
   * @param actual the TagImageHook we want to make assertions on.
   */
  protected AbstractTagImageHookAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TagImageHook's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TagImageHook's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagImageHook's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TagImageHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagImageHook's containerName is equal to the given one.
   * @param containerName the given containerName to compare the actual TagImageHook's containerName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagImageHook's containerName is not equal to the given one.
   */
  public S hasContainerName(String containerName) {
    // check that actual TagImageHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting containerName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerName = actual.getContainerName();
    if (!Objects.areEqual(actualContainerName, containerName)) {
      failWithMessage(assertjErrorMessage, actual, containerName, actualContainerName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagImageHook's to is equal to the given one.
   * @param to the given to to compare the actual TagImageHook's to to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagImageHook's to is not equal to the given one.
   */
  public S hasTo(io.fabric8.kubernetes.api.model.ObjectReference to) {
    // check that actual TagImageHook we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting to of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualTo = actual.getTo();
    if (!Objects.areEqual(actualTo, to)) {
      failWithMessage(assertjErrorMessage, actual, to, actualTo);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
