package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedTagEventListFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedTagEventListFluentAssert<S extends AbstractNamedTagEventListFluentAssert<S, A>, A extends NamedTagEventListFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedTagEventListFluentAssert}</code> to make assertions on actual NamedTagEventListFluent.
   * @param actual the NamedTagEventListFluent we want to make assertions on.
   */
  protected AbstractNamedTagEventListFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedTagEventListFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedTagEventListFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagEventListFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent's conditions contains the given TagEventCondition elements.
   * @param conditions the given elements that should be contained in actual NamedTagEventListFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's conditions does not contain all given TagEventCondition elements.
   */
  public S hasConditions(TagEventCondition... conditions) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given TagEventCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent's conditions contains <b>only<b> the given TagEventCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual NamedTagEventListFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's conditions does not contain all given TagEventCondition elements.
   */
  public S hasOnlyConditions(TagEventCondition... conditions) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given TagEventCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent's conditions does not contain the given TagEventCondition elements.
   *
   * @param conditions the given elements that should not be in actual NamedTagEventListFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's conditions contains any given TagEventCondition elements.
   */
  public S doesNotHaveConditions(TagEventCondition... conditions) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given TagEventCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NamedTagEventListFluent's items contains the given TagEvent elements.
   * @param items the given elements that should be contained in actual NamedTagEventListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's items does not contain all given TagEvent elements.
   */
  public S hasItems(TagEvent... items) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given TagEvent varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent's items contains <b>only<b> the given TagEvent elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual NamedTagEventListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's items does not contain all given TagEvent elements.
   */
  public S hasOnlyItems(TagEvent... items) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given TagEvent varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent's items does not contain the given TagEvent elements.
   *
   * @param items the given elements that should not be in actual NamedTagEventListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's items contains any given TagEvent elements.
   */
  public S doesNotHaveItems(TagEvent... items) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given TagEvent varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedTagEventListFluent has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual NamedTagEventListFluent's items is not empty.
   */
  public S hasNoItems() {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NamedTagEventListFluent's tag is equal to the given one.
   * @param tag the given tag to compare the actual NamedTagEventListFluent's tag to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedTagEventListFluent's tag is not equal to the given one.
   */
  public S hasTag(String tag) {
    // check that actual NamedTagEventListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting tag of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTag = actual.getTag();
    if (!Objects.areEqual(actualTag, tag)) {
      failWithMessage(assertjErrorMessage, actual, tag, actualTag);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
