package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Event} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEventAssert<S extends AbstractEventAssert<S, A>, A extends Event> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEventAssert}</code> to make assertions on actual Event.
   * @param actual the Event we want to make assertions on.
   */
  protected AbstractEventAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Event's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Event's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Event's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Event.ApiVersion apiVersion) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Event.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's count is equal to the given one.
   * @param count the given count to compare the actual Event's count to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's count is not equal to the given one.
   */
  public S hasCount(Integer count) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting count of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCount = actual.getCount();
    if (!Objects.areEqual(actualCount, count)) {
      failWithMessage(assertjErrorMessage, actual, count, actualCount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's firstTimestamp is equal to the given one.
   * @param firstTimestamp the given firstTimestamp to compare the actual Event's firstTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's firstTimestamp is not equal to the given one.
   */
  public S hasFirstTimestamp(String firstTimestamp) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting firstTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFirstTimestamp = actual.getFirstTimestamp();
    if (!Objects.areEqual(actualFirstTimestamp, firstTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, firstTimestamp, actualFirstTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's involvedObject is equal to the given one.
   * @param involvedObject the given involvedObject to compare the actual Event's involvedObject to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's involvedObject is not equal to the given one.
   */
  public S hasInvolvedObject(ObjectReference involvedObject) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting involvedObject of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectReference actualInvolvedObject = actual.getInvolvedObject();
    if (!Objects.areEqual(actualInvolvedObject, involvedObject)) {
      failWithMessage(assertjErrorMessage, actual, involvedObject, actualInvolvedObject);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's kind is equal to the given one.
   * @param kind the given kind to compare the actual Event's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's lastTimestamp is equal to the given one.
   * @param lastTimestamp the given lastTimestamp to compare the actual Event's lastTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's lastTimestamp is not equal to the given one.
   */
  public S hasLastTimestamp(String lastTimestamp) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastTimestamp = actual.getLastTimestamp();
    if (!Objects.areEqual(actualLastTimestamp, lastTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, lastTimestamp, actualLastTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's message is equal to the given one.
   * @param message the given message to compare the actual Event's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual Event's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's reason is equal to the given one.
   * @param reason the given reason to compare the actual Event's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's source is equal to the given one.
   * @param source the given source to compare the actual Event's source to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's source is not equal to the given one.
   */
  public S hasSource(EventSource source) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting source of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EventSource actualSource = actual.getSource();
    if (!Objects.areEqual(actualSource, source)) {
      failWithMessage(assertjErrorMessage, actual, source, actualSource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Event's type is equal to the given one.
   * @param type the given type to compare the actual Event's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Event's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual Event we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
