/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ServiceStatus;
import io.fabric8.kubernetes.api.model.ServiceStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServiceStatusBuilder
extends ServiceStatusFluent<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;

    public ServiceStatusBuilder() {
        this(new ServiceStatus());
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, new ServiceStatus());
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this.fluent = fluent;
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this.fluent = this;
    }

    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus();
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

