/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.CapabilitiesBuilder;
import io.fabric8.kubernetes.api.model.CapabilitiesFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluent<T extends ContainerFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<String> args = new ArrayList<String>();
    VisitableBuilder<Capabilities, ?> capabilities;
    List<String> command = new ArrayList<String>();
    List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();
    String image;
    String imagePullPolicy;
    VisitableBuilder<Lifecycle, ?> lifecycle;
    VisitableBuilder<Probe, ?> livenessProbe;
    String name;
    List<VisitableBuilder<ContainerPort, ?>> ports = new ArrayList();
    Boolean privileged;
    VisitableBuilder<Probe, ?> readinessProbe;
    VisitableBuilder<ResourceRequirements, ?> resources;
    SecurityContext securityContext;
    String terminationMessagePath;
    List<VisitableBuilder<VolumeMount, ?>> volumeMounts = new ArrayList();
    String workingDir;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToArgs(String item) {
        if (item != null) {
            this.args.add(item);
        }
        return (T)((Object)this);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public T withArgs(List<String> args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (T)((Object)this);
    }

    public Capabilities getCapabilities() {
        return this.capabilities != null ? (Capabilities)this.capabilities.build() : null;
    }

    public T withCapabilities(Capabilities capabilities) {
        if (capabilities != null) {
            this.capabilities = new CapabilitiesBuilder(capabilities);
            this._visitables.add(this.capabilities);
        }
        return (T)((Object)this);
    }

    public CapabilitiesNested<T> withNewCapabilities() {
        return new CapabilitiesNested();
    }

    public T addToCommand(String item) {
        if (item != null) {
            this.command.add(item);
        }
        return (T)((Object)this);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public T withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (T)((Object)this);
    }

    public T addToEnv(EnvVar item) {
        if (item != null) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (T)((Object)this);
    }

    public List<EnvVar> getEnv() {
        return this.build(this.env);
    }

    public T withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)((Object)this);
    }

    public EnvNested<T> addNewEnv() {
        return new EnvNested();
    }

    public String getImage() {
        return this.image;
    }

    public T withImage(String image) {
        this.image = image;
        return (T)((Object)this);
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public T withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (T)((Object)this);
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle != null ? (Lifecycle)this.lifecycle.build() : null;
    }

    public T withLifecycle(Lifecycle lifecycle) {
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.add(this.lifecycle);
        }
        return (T)((Object)this);
    }

    public LifecycleNested<T> withNewLifecycle() {
        return new LifecycleNested();
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? (Probe)this.livenessProbe.build() : null;
    }

    public T withLivenessProbe(Probe livenessProbe) {
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (T)((Object)this);
    }

    public LivenessProbeNested<T> withNewLivenessProbe() {
        return new LivenessProbeNested();
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)((Object)this);
    }

    public T addToPorts(ContainerPort item) {
        if (item != null) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)((Object)this);
    }

    public List<ContainerPort> getPorts() {
        return this.build(this.ports);
    }

    public T withPorts(List<ContainerPort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)((Object)this);
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public T addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public T withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (T)((Object)this);
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? (Probe)this.readinessProbe.build() : null;
    }

    public T withReadinessProbe(Probe readinessProbe) {
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (T)((Object)this);
    }

    public ReadinessProbeNested<T> withNewReadinessProbe() {
        return new ReadinessProbeNested();
    }

    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)((Object)this);
    }

    public ResourcesNested<T> withNewResources() {
        return new ResourcesNested();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public T withSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return (T)((Object)this);
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public T withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (T)((Object)this);
    }

    public T addToVolumeMounts(VolumeMount item) {
        if (item != null) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.add(builder);
            this.volumeMounts.add(builder);
        }
        return (T)((Object)this);
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.build(this.volumeMounts);
    }

    public T withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (T)((Object)this);
    }

    public VolumeMountsNested<T> addNewVolumeMount() {
        return new VolumeMountsNested();
    }

    public T addNewVolumeMount(String mountPath, String name, Boolean readOnly) {
        return this.addToVolumeMounts(new VolumeMount(mountPath, name, readOnly));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public T withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        private final VolumeMountBuilder builder = new VolumeMountBuilder(this);

        public N and() {
            return (N)ContainerFluent.this.addToVolumeMounts(this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        private final ResourceRequirementsBuilder builder = new ResourceRequirementsBuilder(this);

        public N endResources() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withResources(this.builder.build());
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        private final ProbeBuilder builder = new ProbeBuilder(this);

        public N endReadinessProbe() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withReadinessProbe(this.builder.build());
        }
    }

    public class PortsNested<N>
    extends ContainerPortFluent<PortsNested<N>>
    implements Nested<N> {
        private final ContainerPortBuilder builder = new ContainerPortBuilder(this);

        public N endPort() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToPorts(this.builder.build());
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        private final ProbeBuilder builder = new ProbeBuilder(this);

        public N and() {
            return (N)ContainerFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class LifecycleNested<N>
    extends LifecycleFluent<LifecycleNested<N>>
    implements Nested<N> {
        private final LifecycleBuilder builder = new LifecycleBuilder(this);

        public N endLifecycle() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withLifecycle(this.builder.build());
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        private final EnvVarBuilder builder = new EnvVarBuilder(this);

        public N endEnv() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.addToEnv(this.builder.build());
        }
    }

    public class CapabilitiesNested<N>
    extends CapabilitiesFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        private final CapabilitiesBuilder builder = new CapabilitiesBuilder(this);

        public N endCapabilities() {
            return this.and();
        }

        public N and() {
            return (N)ContainerFluent.this.withCapabilities(this.builder.build());
        }
    }
}

