package io.fabric8.kubernetes.api.model.config;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Config} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigAssert<S extends AbstractConfigAssert<S, A>, A extends Config> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigAssert}</code> to make assertions on actual Config.
   * @param actual the Config we want to make assertions on.
   */
  protected AbstractConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Config's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Config's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Config's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Config.ApiVersion apiVersion) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Config.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's clusters contains the given NamedCluster elements.
   * @param clusters the given elements that should be contained in actual Config's clusters.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's clusters does not contain all given NamedCluster elements.
   */
  public S hasClusters(NamedCluster... clusters) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // check that given NamedCluster varargs is not null.
    if (clusters == null) throw new AssertionError("Expecting clusters parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getClusters(), clusters);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config has no clusters.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's clusters is not empty.
   */
  public S hasNoClusters() {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have clusters but had :\n  <%s>";
    
    // check
    if (actual.getClusters().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getClusters());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Config's contexts contains the given NamedContext elements.
   * @param contexts the given elements that should be contained in actual Config's contexts.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's contexts does not contain all given NamedContext elements.
   */
  public S hasContexts(NamedContext... contexts) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // check that given NamedContext varargs is not null.
    if (contexts == null) throw new AssertionError("Expecting contexts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContexts(), contexts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config has no contexts.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's contexts is not empty.
   */
  public S hasNoContexts() {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have contexts but had :\n  <%s>";
    
    // check
    if (actual.getContexts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContexts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Config's currentContext is equal to the given one.
   * @param currentContext the given currentContext to compare the actual Config's currentContext to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's currentContext is not equal to the given one.
   */
  public S hasCurrentContext(String currentContext) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected currentContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCurrentContext = actual.getCurrentContext();
    if (!Objects.areEqual(actualCurrentContext, currentContext)) {
      failWithMessage(assertjErrorMessage, actual, currentContext, actualCurrentContext);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual Config's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) throw new AssertionError("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Config's kind is equal to the given one.
   * @param kind the given kind to compare the actual Config's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's preferences is equal to the given one.
   * @param preferences the given preferences to compare the actual Config's preferences to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Config's preferences is not equal to the given one.
   */
  public S hasPreferences(Preferences preferences) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected preferences of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Preferences actualPreferences = actual.getPreferences();
    if (!Objects.areEqual(actualPreferences, preferences)) {
      failWithMessage(assertjErrorMessage, actual, preferences, actualPreferences);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config's users contains the given NamedAuthInfo elements.
   * @param users the given elements that should be contained in actual Config's users.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's users does not contain all given NamedAuthInfo elements.
   */
  public S hasUsers(NamedAuthInfo... users) {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // check that given NamedAuthInfo varargs is not null.
    if (users == null) throw new AssertionError("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Config has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual Config's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual Config we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
