/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ProbeBuilder
extends ProbeFluent<ProbeBuilder>
implements Builder<Probe> {
    ProbeFluent<?> fluent;

    public ProbeBuilder() {
        this(new Probe());
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, new Probe());
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this.fluent = fluent;
        fluent.withExec(instance.getExec());
        fluent.withHttpGet(instance.getHttpGet());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withTcpSocket(instance.getTcpSocket());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
    }

    public ProbeBuilder(Probe instance) {
        this.fluent = this;
        this.withExec(instance.getExec());
        this.withHttpGet(instance.getHttpGet());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withTcpSocket(instance.getTcpSocket());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
    }

    public Probe build() {
        Probe buildable = new Probe(this.fluent.getExec(), this.fluent.getHttpGet(), this.fluent.getInitialDelaySeconds(), this.fluent.getTcpSocket(), this.fluent.getTimeoutSeconds());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

