/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fabric8.KubernetesJson;
import io.fabric8.kubernetes.api.model.BaseKubernetesList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "apiVersion", "creationTimestamp", "deletionTimestamp", "generateName", "id", "items", "kind", "namespace", "resourceVersion", "selfLink", "uid"})
public class KubernetesList
extends BaseKubernetesList
implements KubernetesJson {
    @JsonIgnore
    private final List<Service> services = new ArrayList<Service>();
    @JsonIgnore
    private final List<ReplicationController> replicationControllers = new ArrayList<ReplicationController>();
    @JsonIgnore
    private final List<Pod> pods = new ArrayList<Pod>();
    @JsonIgnore
    private final List<BuildConfig> buildConfigs = new ArrayList<BuildConfig>();
    @JsonIgnore
    private final List<DeploymentConfig> deploymentConfigs = new ArrayList<DeploymentConfig>();
    @JsonIgnore
    private final List<ImageStream> imageStreams = new ArrayList<ImageStream>();
    @JsonIgnore
    private final List<Route> routes = new ArrayList<Route>();
    @JsonIgnore
    private final List<Template> templates = new ArrayList<Template>();
    @JsonIgnore
    private final List<OAuthClient> oAuthClients = new ArrayList<OAuthClient>();
    @JsonIgnore
    private final List<OAuthClientAuthorization> oAuthClientAuthorizations = new ArrayList<OAuthClientAuthorization>();
    @JsonIgnore
    private final List<OAuthAccessToken> oAuthAccessTokens = new ArrayList<OAuthAccessToken>();
    @JsonIgnore
    private final List<Namespace> namespaces = new ArrayList<Namespace>();
    @JsonIgnore
    private final List<Secret> secrets = new ArrayList<Secret>();

    public KubernetesList() {
    }

    public KubernetesList(BaseKubernetesList.ApiVersion apiVersion, List<HasMetadata> items, String kind, ListMeta metadata, List<Service> services, List<ReplicationController> replicationControllers, List<Pod> pods, List<BuildConfig> buildConfigs, List<DeploymentConfig> deploymentConfigs, List<ImageStream> imageStreams, List<Route> routes, List<Template> templates, List<OAuthClient> oAuthClients, List<OAuthClientAuthorization> oAuthClientAuthorizations, List<OAuthAccessToken> oAuthAccessTokens, List<Namespace> namespaces, List<Secret> secrets) {
        super(apiVersion, items, kind, metadata);
        this.setItems(items);
        this.services.addAll(services != null ? services : Collections.emptyList());
        this.replicationControllers.addAll(replicationControllers != null ? replicationControllers : Collections.emptyList());
        this.pods.addAll(pods != null ? pods : Collections.emptyList());
        this.buildConfigs.addAll(buildConfigs != null ? buildConfigs : Collections.emptyList());
        this.deploymentConfigs.addAll(deploymentConfigs != null ? deploymentConfigs : Collections.emptyList());
        this.imageStreams.addAll(imageStreams != null ? imageStreams : Collections.emptyList());
        this.routes.addAll(routes != null ? routes : Collections.emptyList());
        this.templates.addAll(templates != null ? templates : Collections.emptyList());
        this.oAuthClients.addAll(oAuthClients != null ? oAuthClients : Collections.emptyList());
        this.oAuthClientAuthorizations.addAll(oAuthClientAuthorizations != null ? oAuthClientAuthorizations : Collections.emptyList());
        this.oAuthAccessTokens.addAll(oAuthAccessTokens != null ? oAuthAccessTokens : Collections.emptyList());
        this.namespaces.addAll(namespaces != null ? namespaces : Collections.emptyList());
        this.secrets.addAll(secrets != null ? secrets : Collections.emptyList());
    }

    @Override
    @JsonProperty(value="items")
    public List<HasMetadata> getItems() {
        ArrayList<HasMetadata> allItems = new ArrayList<HasMetadata>(super.getItems());
        allItems.addAll(this.services);
        allItems.addAll(this.replicationControllers);
        allItems.addAll(this.pods);
        allItems.addAll(this.buildConfigs);
        allItems.addAll(this.deploymentConfigs);
        allItems.addAll(this.imageStreams);
        allItems.addAll(this.routes);
        allItems.addAll(this.templates);
        allItems.addAll(this.oAuthClients);
        allItems.addAll(this.oAuthClientAuthorizations);
        allItems.addAll(this.oAuthAccessTokens);
        allItems.addAll(this.namespaces);
        allItems.addAll(this.secrets);
        return allItems;
    }

    @Override
    @JsonProperty(value="items")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=KubernetesList.class, name="List"), @JsonSubTypes.Type(value=Service.class, name="Service"), @JsonSubTypes.Type(value=Pod.class, name="Pod"), @JsonSubTypes.Type(value=ReplicationController.class, name="ReplicationController"), @JsonSubTypes.Type(value=BuildConfig.class, name="BuildConfig"), @JsonSubTypes.Type(value=DeploymentConfig.class, name="DeploymentConfig"), @JsonSubTypes.Type(value=ImageStream.class, name="ImageStream"), @JsonSubTypes.Type(value=Route.class, name="Route"), @JsonSubTypes.Type(value=Template.class, name="Template"), @JsonSubTypes.Type(value=OAuthClient.class, name="OAuthClient"), @JsonSubTypes.Type(value=OAuthClientAuthorization.class, name="OAuthClientAuthorization"), @JsonSubTypes.Type(value=OAuthAccessToken.class, name="OAuthAccessToken"), @JsonSubTypes.Type(value=Namespace.class, name="Namespace"), @JsonSubTypes.Type(value=Secret.class, name="Secrets")})
    public void setItems(List<HasMetadata> items) {
        for (HasMetadata item : items) {
            if (item instanceof Service) {
                this.services.add((Service)item);
                continue;
            }
            if (item instanceof ReplicationController) {
                this.replicationControllers.add((ReplicationController)item);
                continue;
            }
            if (item instanceof Pod) {
                this.pods.add((Pod)item);
                continue;
            }
            if (item instanceof BuildConfig) {
                this.buildConfigs.add((BuildConfig)item);
                continue;
            }
            if (item instanceof DeploymentConfig) {
                this.deploymentConfigs.add((DeploymentConfig)item);
                continue;
            }
            if (item instanceof ImageStream) {
                this.imageStreams.add((ImageStream)item);
                continue;
            }
            if (item instanceof Route) {
                this.routes.add((Route)item);
                continue;
            }
            if (item instanceof Template) {
                this.templates.add((Template)item);
                continue;
            }
            if (item instanceof OAuthClient) {
                this.oAuthClients.add((OAuthClient)item);
                continue;
            }
            if (item instanceof OAuthClientAuthorization) {
                this.oAuthClientAuthorizations.add((OAuthClientAuthorization)item);
                continue;
            }
            if (item instanceof OAuthAccessToken) {
                this.oAuthAccessTokens.add((OAuthAccessToken)item);
                continue;
            }
            if (item instanceof Namespace) {
                this.namespaces.add((Namespace)item);
                continue;
            }
            if (!(item instanceof Secret)) continue;
            this.secrets.add((Secret)item);
        }
    }

    @JsonIgnore
    public List<Service> getServices() {
        return this.services;
    }

    @JsonIgnore
    public List<ReplicationController> getReplicationControllers() {
        return this.replicationControllers;
    }

    @JsonIgnore
    public List<Pod> getPods() {
        return this.pods;
    }

    @JsonIgnore
    public List<BuildConfig> getBuildConfigs() {
        return this.buildConfigs;
    }

    @JsonIgnore
    public List<DeploymentConfig> getDeploymentConfigs() {
        return this.deploymentConfigs;
    }

    @JsonIgnore
    public List<ImageStream> getImageStreams() {
        return this.imageStreams;
    }

    @JsonIgnore
    public List<Route> getRoutes() {
        return this.routes;
    }

    @JsonIgnore
    public List<Template> getTemplates() {
        return this.templates;
    }

    @JsonIgnore
    public List<OAuthClient> getOAuthClients() {
        return this.oAuthClients;
    }

    @JsonIgnore
    public List<OAuthClientAuthorization> getOAuthClientAuthorizations() {
        return this.oAuthClientAuthorizations;
    }

    @JsonIgnore
    public List<OAuthAccessToken> getOAuthAccessTokens() {
        return this.oAuthAccessTokens;
    }

    @JsonIgnore
    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    @JsonIgnore
    public List<Secret> getSecrets() {
        return this.secrets;
    }
}

