package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EnvVarSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEnvVarSourceAssert<S extends AbstractEnvVarSourceAssert<S, A>, A extends EnvVarSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEnvVarSourceAssert}</code> to make assertions on actual EnvVarSource.
   * @param actual the EnvVarSource we want to make assertions on.
   */
  protected AbstractEnvVarSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EnvVarSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EnvVarSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EnvVarSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EnvVarSource's fieldPath is equal to the given one.
   * @param fieldPath the given fieldPath to compare the actual EnvVarSource's fieldPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EnvVarSource's fieldPath is not equal to the given one.
   */
  public S hasFieldPath(ObjectFieldSelector fieldPath) {
    // check that actual EnvVarSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected fieldPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectFieldSelector actualFieldPath = actual.getFieldPath();
    if (!Objects.areEqual(actualFieldPath, fieldPath)) {
      failWithMessage(assertjErrorMessage, actual, fieldPath, actualFieldPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
