/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.base;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.base.StatusDetails;
import io.fabric8.kubernetes.api.model.base.StatusDetailsFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusDetailsBuilder
extends StatusDetailsFluent<StatusDetailsBuilder>
implements Builder<StatusDetails> {
    StatusDetailsFluent<?> fluent;

    public StatusDetailsBuilder() {
        this(new StatusDetails());
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent) {
        this(fluent, new StatusDetails());
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent, StatusDetails instance) {
        this.fluent = fluent;
        fluent.withCauses(instance.getCauses());
        fluent.withId(instance.getId());
        fluent.withKind(instance.getKind());
        fluent.withRetryAfterSeconds(instance.getRetryAfterSeconds());
    }

    public StatusDetailsBuilder(StatusDetails instance) {
        this.fluent = this;
        this.withCauses(instance.getCauses());
        this.withId(instance.getId());
        this.withKind(instance.getKind());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
    }

    public StatusDetails build() {
        StatusDetails buildable = new StatusDetails(this.fluent.getCauses(), this.fluent.getId(), this.fluent.getKind(), this.fluent.getRetryAfterSeconds());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

