/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServicePortBuilder
extends ServicePortFluent<ServicePortBuilder>
implements Builder<ServicePort> {
    ServicePortFluent<?> fluent;

    public ServicePortBuilder() {
        this(new ServicePort());
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent) {
        this(fluent, new ServicePort());
    }

    public ServicePortBuilder(ServicePortFluent<?> fluent, ServicePort instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        fluent.withTargetPort(instance.getTargetPort());
    }

    public ServicePortBuilder(ServicePort instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
    }

    public ServicePort build() {
        ServicePort buildable = new ServicePort(this.fluent.getName(), this.fluent.getPort(), this.fluent.getProtocol(), this.fluent.getTargetPort());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

