/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ContainerState;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"containerID", "image", "imageID", "lastState", "name", "ready", "restartCount", "state"})
public class ContainerStatus {
    @JsonProperty(value="containerID")
    private String containerID;
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="imageID")
    private String imageID;
    @JsonProperty(value="lastState")
    @Valid
    private ContainerState lastState;
    @JsonProperty(value="name")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max=63)
    private String name;
    @JsonProperty(value="ready")
    private Boolean ready;
    @JsonProperty(value="restartCount")
    private Integer restartCount;
    @JsonProperty(value="state")
    @Valid
    private ContainerState state;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ContainerStatus() {
    }

    public ContainerStatus(String containerID, String image, String imageID, ContainerState lastState, String name, Boolean ready, Integer restartCount, ContainerState state) {
        this.containerID = containerID;
        this.image = image;
        this.imageID = imageID;
        this.lastState = lastState;
        this.name = name;
        this.ready = ready;
        this.restartCount = restartCount;
        this.state = state;
    }

    @JsonProperty(value="containerID")
    public String getContainerID() {
        return this.containerID;
    }

    @JsonProperty(value="containerID")
    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    public void setImage(String image) {
        this.image = image;
    }

    @JsonProperty(value="imageID")
    public String getImageID() {
        return this.imageID;
    }

    @JsonProperty(value="imageID")
    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    @JsonProperty(value="lastState")
    public ContainerState getLastState() {
        return this.lastState;
    }

    @JsonProperty(value="lastState")
    public void setLastState(ContainerState lastState) {
        this.lastState = lastState;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="ready")
    public Boolean getReady() {
        return this.ready;
    }

    @JsonProperty(value="ready")
    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    @JsonProperty(value="restartCount")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    @JsonProperty(value="restartCount")
    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    @JsonProperty(value="state")
    public ContainerState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(ContainerState state) {
        this.state = state;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.containerID).append((Object)this.image).append((Object)this.imageID).append((Object)this.lastState).append((Object)this.name).append((Object)this.ready).append((Object)this.restartCount).append((Object)this.state).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ContainerStatus)) {
            return false;
        }
        ContainerStatus rhs = (ContainerStatus)other;
        return new EqualsBuilder().append((Object)this.containerID, (Object)rhs.containerID).append((Object)this.image, (Object)rhs.image).append((Object)this.imageID, (Object)rhs.imageID).append((Object)this.lastState, (Object)rhs.lastState).append((Object)this.name, (Object)rhs.name).append((Object)this.ready, (Object)rhs.ready).append((Object)this.restartCount, (Object)rhs.restartCount).append((Object)this.state, (Object)rhs.state).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }
}

