package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubeSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubeSchemaAssert<S extends AbstractKubeSchemaAssert<S, A>, A extends KubeSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubeSchemaAssert}</code> to make assertions on actual KubeSchema.
   * @param actual the KubeSchema we want to make assertions on.
   */
  protected AbstractKubeSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubeSchema's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KubeSchema's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's baseKubernetesList is equal to the given one.
   * @param baseKubernetesList the given baseKubernetesList to compare the actual KubeSchema's baseKubernetesList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's baseKubernetesList is not equal to the given one.
   */
  public S hasBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected baseKubernetesList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BaseKubernetesList actualBaseKubernetesList = actual.getBaseKubernetesList();
    if (!Objects.areEqual(actualBaseKubernetesList, baseKubernetesList)) {
      failWithMessage(assertjErrorMessage, actual, baseKubernetesList, actualBaseKubernetesList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's buildConfigList is equal to the given one.
   * @param buildConfigList the given buildConfigList to compare the actual KubeSchema's buildConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's buildConfigList is not equal to the given one.
   */
  public S hasBuildConfigList(io.fabric8.openshift.api.model.BuildConfigList buildConfigList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildConfigList actualBuildConfigList = actual.getBuildConfigList();
    if (!Objects.areEqual(actualBuildConfigList, buildConfigList)) {
      failWithMessage(assertjErrorMessage, actual, buildConfigList, actualBuildConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's buildList is equal to the given one.
   * @param buildList the given buildList to compare the actual KubeSchema's buildList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's buildList is not equal to the given one.
   */
  public S hasBuildList(io.fabric8.openshift.api.model.BuildList buildList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected buildList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildList actualBuildList = actual.getBuildList();
    if (!Objects.areEqual(actualBuildList, buildList)) {
      failWithMessage(assertjErrorMessage, actual, buildList, actualBuildList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's containerStatus is equal to the given one.
   * @param containerStatus the given containerStatus to compare the actual KubeSchema's containerStatus to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's containerStatus is not equal to the given one.
   */
  public S hasContainerStatus(ContainerStatus containerStatus) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerStatus of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStatus actualContainerStatus = actual.getContainerStatus();
    if (!Objects.areEqual(actualContainerStatus, containerStatus)) {
      failWithMessage(assertjErrorMessage, actual, containerStatus, actualContainerStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's deploymentConfigList is equal to the given one.
   * @param deploymentConfigList the given deploymentConfigList to compare the actual KubeSchema's deploymentConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's deploymentConfigList is not equal to the given one.
   */
  public S hasDeploymentConfigList(io.fabric8.openshift.api.model.DeploymentConfigList deploymentConfigList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deploymentConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.DeploymentConfigList actualDeploymentConfigList = actual.getDeploymentConfigList();
    if (!Objects.areEqual(actualDeploymentConfigList, deploymentConfigList)) {
      failWithMessage(assertjErrorMessage, actual, deploymentConfigList, actualDeploymentConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's endpoints is equal to the given one.
   * @param endpoints the given endpoints to compare the actual KubeSchema's endpoints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's endpoints is not equal to the given one.
   */
  public S hasEndpoints(Endpoints endpoints) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Endpoints actualEndpoints = actual.getEndpoints();
    if (!Objects.areEqual(actualEndpoints, endpoints)) {
      failWithMessage(assertjErrorMessage, actual, endpoints, actualEndpoints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's endpointsList is equal to the given one.
   * @param endpointsList the given endpointsList to compare the actual KubeSchema's endpointsList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's endpointsList is not equal to the given one.
   */
  public S hasEndpointsList(EndpointsList endpointsList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpointsList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EndpointsList actualEndpointsList = actual.getEndpointsList();
    if (!Objects.areEqual(actualEndpointsList, endpointsList)) {
      failWithMessage(assertjErrorMessage, actual, endpointsList, actualEndpointsList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's envVar is equal to the given one.
   * @param envVar the given envVar to compare the actual KubeSchema's envVar to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's envVar is not equal to the given one.
   */
  public S hasEnvVar(EnvVar envVar) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected envVar of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EnvVar actualEnvVar = actual.getEnvVar();
    if (!Objects.areEqual(actualEnvVar, envVar)) {
      failWithMessage(assertjErrorMessage, actual, envVar, actualEnvVar);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's imageList is equal to the given one.
   * @param imageList the given imageList to compare the actual KubeSchema's imageList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's imageList is not equal to the given one.
   */
  public S hasImageList(io.fabric8.openshift.api.model.ImageList imageList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageList actualImageList = actual.getImageList();
    if (!Objects.areEqual(actualImageList, imageList)) {
      failWithMessage(assertjErrorMessage, actual, imageList, actualImageList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's imageStreamList is equal to the given one.
   * @param imageStreamList the given imageStreamList to compare the actual KubeSchema's imageStreamList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's imageStreamList is not equal to the given one.
   */
  public S hasImageStreamList(io.fabric8.openshift.api.model.ImageStreamList imageStreamList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imageStreamList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageStreamList actualImageStreamList = actual.getImageStreamList();
    if (!Objects.areEqual(actualImageStreamList, imageStreamList)) {
      failWithMessage(assertjErrorMessage, actual, imageStreamList, actualImageStreamList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual KubeSchema's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's namespace is not equal to the given one.
   */
  public S hasNamespace(Namespace namespace) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Namespace actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's namespaceList is equal to the given one.
   * @param namespaceList the given namespaceList to compare the actual KubeSchema's namespaceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's namespaceList is not equal to the given one.
   */
  public S hasNamespaceList(NamespaceList namespaceList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespaceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NamespaceList actualNamespaceList = actual.getNamespaceList();
    if (!Objects.areEqual(actualNamespaceList, namespaceList)) {
      failWithMessage(assertjErrorMessage, actual, namespaceList, actualNamespaceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's node is equal to the given one.
   * @param node the given node to compare the actual KubeSchema's node to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's node is not equal to the given one.
   */
  public S hasNode(Node node) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected node of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Node actualNode = actual.getNode();
    if (!Objects.areEqual(actualNode, node)) {
      failWithMessage(assertjErrorMessage, actual, node, actualNode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's nodeList is equal to the given one.
   * @param nodeList the given nodeList to compare the actual KubeSchema's nodeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's nodeList is not equal to the given one.
   */
  public S hasNodeList(NodeList nodeList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeList actualNodeList = actual.getNodeList();
    if (!Objects.areEqual(actualNodeList, nodeList)) {
      failWithMessage(assertjErrorMessage, actual, nodeList, actualNodeList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthAccessToken is equal to the given one.
   * @param oAuthAccessToken the given oAuthAccessToken to compare the actual KubeSchema's oAuthAccessToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthAccessToken is not equal to the given one.
   */
  public S hasOAuthAccessToken(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessToken) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAccessToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAccessToken actualOAuthAccessToken = actual.getOAuthAccessToken();
    if (!Objects.areEqual(actualOAuthAccessToken, oAuthAccessToken)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAccessToken, actualOAuthAccessToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthAccessTokenList is equal to the given one.
   * @param oAuthAccessTokenList the given oAuthAccessTokenList to compare the actual KubeSchema's oAuthAccessTokenList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthAccessTokenList is not equal to the given one.
   */
  public S hasOAuthAccessTokenList(io.fabric8.openshift.api.model.OAuthAccessTokenList oAuthAccessTokenList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAccessTokenList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAccessTokenList actualOAuthAccessTokenList = actual.getOAuthAccessTokenList();
    if (!Objects.areEqual(actualOAuthAccessTokenList, oAuthAccessTokenList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAccessTokenList, actualOAuthAccessTokenList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthAuthorizeToken is equal to the given one.
   * @param oAuthAuthorizeToken the given oAuthAuthorizeToken to compare the actual KubeSchema's oAuthAuthorizeToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthAuthorizeToken is not equal to the given one.
   */
  public S hasOAuthAuthorizeToken(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeToken) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAuthorizeToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAuthorizeToken actualOAuthAuthorizeToken = actual.getOAuthAuthorizeToken();
    if (!Objects.areEqual(actualOAuthAuthorizeToken, oAuthAuthorizeToken)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAuthorizeToken, actualOAuthAuthorizeToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthAuthorizeTokenList is equal to the given one.
   * @param oAuthAuthorizeTokenList the given oAuthAuthorizeTokenList to compare the actual KubeSchema's oAuthAuthorizeTokenList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthAuthorizeTokenList is not equal to the given one.
   */
  public S hasOAuthAuthorizeTokenList(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList oAuthAuthorizeTokenList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthAuthorizeTokenList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenList actualOAuthAuthorizeTokenList = actual.getOAuthAuthorizeTokenList();
    if (!Objects.areEqual(actualOAuthAuthorizeTokenList, oAuthAuthorizeTokenList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAuthorizeTokenList, actualOAuthAuthorizeTokenList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthClient is equal to the given one.
   * @param oAuthClient the given oAuthClient to compare the actual KubeSchema's oAuthClient to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthClient is not equal to the given one.
   */
  public S hasOAuthClient(io.fabric8.openshift.api.model.OAuthClient oAuthClient) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClient of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClient actualOAuthClient = actual.getOAuthClient();
    if (!Objects.areEqual(actualOAuthClient, oAuthClient)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClient, actualOAuthClient);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthClientAuthorization is equal to the given one.
   * @param oAuthClientAuthorization the given oAuthClientAuthorization to compare the actual KubeSchema's oAuthClientAuthorization to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthClientAuthorization is not equal to the given one.
   */
  public S hasOAuthClientAuthorization(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorization) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClientAuthorization of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientAuthorization actualOAuthClientAuthorization = actual.getOAuthClientAuthorization();
    if (!Objects.areEqual(actualOAuthClientAuthorization, oAuthClientAuthorization)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientAuthorization, actualOAuthClientAuthorization);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthClientAuthorizationList is equal to the given one.
   * @param oAuthClientAuthorizationList the given oAuthClientAuthorizationList to compare the actual KubeSchema's oAuthClientAuthorizationList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthClientAuthorizationList is not equal to the given one.
   */
  public S hasOAuthClientAuthorizationList(io.fabric8.openshift.api.model.OAuthClientAuthorizationList oAuthClientAuthorizationList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClientAuthorizationList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientAuthorizationList actualOAuthClientAuthorizationList = actual.getOAuthClientAuthorizationList();
    if (!Objects.areEqual(actualOAuthClientAuthorizationList, oAuthClientAuthorizationList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientAuthorizationList, actualOAuthClientAuthorizationList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's oAuthClientList is equal to the given one.
   * @param oAuthClientList the given oAuthClientList to compare the actual KubeSchema's oAuthClientList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's oAuthClientList is not equal to the given one.
   */
  public S hasOAuthClientList(io.fabric8.openshift.api.model.OAuthClientList oAuthClientList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected oAuthClientList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientList actualOAuthClientList = actual.getOAuthClientList();
    if (!Objects.areEqual(actualOAuthClientList, oAuthClientList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientList, actualOAuthClientList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's objectMeta is equal to the given one.
   * @param objectMeta the given objectMeta to compare the actual KubeSchema's objectMeta to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's objectMeta is not equal to the given one.
   */
  public S hasObjectMeta(ObjectMeta objectMeta) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected objectMeta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualObjectMeta = actual.getObjectMeta();
    if (!Objects.areEqual(actualObjectMeta, objectMeta)) {
      failWithMessage(assertjErrorMessage, actual, objectMeta, actualObjectMeta);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's podList is equal to the given one.
   * @param podList the given podList to compare the actual KubeSchema's podList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's podList is not equal to the given one.
   */
  public S hasPodList(PodList podList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodList actualPodList = actual.getPodList();
    if (!Objects.areEqual(actualPodList, podList)) {
      failWithMessage(assertjErrorMessage, actual, podList, actualPodList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's quantity is equal to the given one.
   * @param quantity the given quantity to compare the actual KubeSchema's quantity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's quantity is not equal to the given one.
   */
  public S hasQuantity(io.fabric8.kubernetes.api.model.resource.Quantity quantity) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected quantity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.resource.Quantity actualQuantity = actual.getQuantity();
    if (!Objects.areEqual(actualQuantity, quantity)) {
      failWithMessage(assertjErrorMessage, actual, quantity, actualQuantity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's replicationControllerList is equal to the given one.
   * @param replicationControllerList the given replicationControllerList to compare the actual KubeSchema's replicationControllerList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's replicationControllerList is not equal to the given one.
   */
  public S hasReplicationControllerList(ReplicationControllerList replicationControllerList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected replicationControllerList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerList actualReplicationControllerList = actual.getReplicationControllerList();
    if (!Objects.areEqual(actualReplicationControllerList, replicationControllerList)) {
      failWithMessage(assertjErrorMessage, actual, replicationControllerList, actualReplicationControllerList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's routeList is equal to the given one.
   * @param routeList the given routeList to compare the actual KubeSchema's routeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's routeList is not equal to the given one.
   */
  public S hasRouteList(io.fabric8.openshift.api.model.RouteList routeList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected routeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RouteList actualRouteList = actual.getRouteList();
    if (!Objects.areEqual(actualRouteList, routeList)) {
      failWithMessage(assertjErrorMessage, actual, routeList, actualRouteList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's secret is equal to the given one.
   * @param secret the given secret to compare the actual KubeSchema's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's secret is not equal to the given one.
   */
  public S hasSecret(Secret secret) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Secret actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's secretList is equal to the given one.
   * @param secretList the given secretList to compare the actual KubeSchema's secretList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's secretList is not equal to the given one.
   */
  public S hasSecretList(SecretList secretList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secretList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecretList actualSecretList = actual.getSecretList();
    if (!Objects.areEqual(actualSecretList, secretList)) {
      failWithMessage(assertjErrorMessage, actual, secretList, actualSecretList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's serviceList is equal to the given one.
   * @param serviceList the given serviceList to compare the actual KubeSchema's serviceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's serviceList is not equal to the given one.
   */
  public S hasServiceList(ServiceList serviceList) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected serviceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceList actualServiceList = actual.getServiceList();
    if (!Objects.areEqual(actualServiceList, serviceList)) {
      failWithMessage(assertjErrorMessage, actual, serviceList, actualServiceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's statusError is equal to the given one.
   * @param statusError the given statusError to compare the actual KubeSchema's statusError to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's statusError is not equal to the given one.
   */
  public S hasStatusError(io.fabric8.kubernetes.api.model.errors.StatusError statusError) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected statusError of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.errors.StatusError actualStatusError = actual.getStatusError();
    if (!Objects.areEqual(actualStatusError, statusError)) {
      failWithMessage(assertjErrorMessage, actual, statusError, actualStatusError);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's tagEvent is equal to the given one.
   * @param tagEvent the given tagEvent to compare the actual KubeSchema's tagEvent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's tagEvent is not equal to the given one.
   */
  public S hasTagEvent(io.fabric8.openshift.api.model.TagEvent tagEvent) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected tagEvent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.TagEvent actualTagEvent = actual.getTagEvent();
    if (!Objects.areEqual(actualTagEvent, tagEvent)) {
      failWithMessage(assertjErrorMessage, actual, tagEvent, actualTagEvent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchema's template is equal to the given one.
   * @param template the given template to compare the actual KubeSchema's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchema's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.openshift.api.model.template.Template template) {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.template.Template actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
