/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluent;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointsFluent<T extends EndpointsFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Endpoints.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<EndpointSubset, ?>> subsets = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Endpoints.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Endpoints.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public T addToSubsets(EndpointSubset item) {
        if (item != null) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.add(builder);
            this.subsets.add(builder);
        }
        return (T)((Object)this);
    }

    public List<EndpointSubset> getSubsets() {
        return this.build(this.subsets);
    }

    public T withSubsets(List<EndpointSubset> subsets) {
        this.subsets.clear();
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (T)((Object)this);
    }

    public SubsetsNested<T> addNewSubset() {
        return new SubsetsNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class SubsetsNested<N>
    extends EndpointSubsetFluent<SubsetsNested<N>>
    implements Nested<N> {
        private final EndpointSubsetBuilder builder = new EndpointSubsetBuilder(this);

        public N endSubset() {
            return this.and();
        }

        public N and() {
            return (N)EndpointsFluent.this.addToSubsets(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)EndpointsFluent.this.withMetadata(this.builder.build());
        }
    }
}

