package io.fabric8.kubernetes.api.model.config;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Cluster} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterAssert<S extends AbstractClusterAssert<S, A>, A extends Cluster> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterAssert}</code> to make assertions on actual Cluster.
   * @param actual the Cluster we want to make assertions on.
   */
  protected AbstractClusterAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Cluster's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Cluster's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cluster's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cluster's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Cluster's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cluster's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cluster's certificateAuthority is equal to the given one.
   * @param certificateAuthority the given certificateAuthority to compare the actual Cluster's certificateAuthority to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cluster's certificateAuthority is not equal to the given one.
   */
  public S hasCertificateAuthority(String certificateAuthority) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected certificateAuthority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCertificateAuthority = actual.getCertificateAuthority();
    if (!Objects.areEqual(actualCertificateAuthority, certificateAuthority)) {
      failWithMessage(assertjErrorMessage, actual, certificateAuthority, actualCertificateAuthority);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cluster's certificateAuthorityData contains the given Integer elements.
   * @param certificateAuthorityData the given elements that should be contained in actual Cluster's certificateAuthorityData.
   * @return this assertion object.
   * @throws AssertionError if the actual Cluster's certificateAuthorityData does not contain all given Integer elements.
   */
  public S hasCertificateAuthorityData(Integer... certificateAuthorityData) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // check that given Integer varargs is not null.
    if (certificateAuthorityData == null) throw new AssertionError("Expecting certificateAuthorityData parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCertificateAuthorityData(), certificateAuthorityData);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cluster has no certificateAuthorityData.
   * @return this assertion object.
   * @throws AssertionError if the actual Cluster's certificateAuthorityData is not empty.
   */
  public S hasNoCertificateAuthorityData() {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have certificateAuthorityData but had :\n  <%s>";
    
    // check
    if (actual.getCertificateAuthorityData().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCertificateAuthorityData());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Cluster's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual Cluster's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual Cluster's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) throw new AssertionError("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cluster has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual Cluster's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Cluster's insecureSkipTlsVerify is equal to the given one.
   * @param insecureSkipTlsVerify the given insecureSkipTlsVerify to compare the actual Cluster's insecureSkipTlsVerify to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cluster's insecureSkipTlsVerify is not equal to the given one.
   */
  public S hasInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected insecureSkipTlsVerify of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualInsecureSkipTlsVerify = actual.getInsecureSkipTlsVerify();
    if (!Objects.areEqual(actualInsecureSkipTlsVerify, insecureSkipTlsVerify)) {
      failWithMessage(assertjErrorMessage, actual, insecureSkipTlsVerify, actualInsecureSkipTlsVerify);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Cluster's server is equal to the given one.
   * @param server the given server to compare the actual Cluster's server to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Cluster's server is not equal to the given one.
   */
  public S hasServer(String server) {
    // check that actual Cluster we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected server of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualServer = actual.getServer();
    if (!Objects.areEqual(actualServer, server)) {
      failWithMessage(assertjErrorMessage, actual, server, actualServer);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
