package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.Capabilities actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert assertThat(io.fabric8.kubernetes.api.model.CapabilitiesBuilder actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert assertThat(io.fabric8.kubernetes.api.model.CapabilitiesFluent actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPortFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddressFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPortFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubsetBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubsetFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HandlerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HandlerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerFluentAssert assertThat(io.fabric8.kubernetes.api.model.HandlerFluent actual) {
    return new io.fabric8.kubernetes.api.model.HandlerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HasMetadataAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HasMetadataAssert assertThat(io.fabric8.kubernetes.api.model.HasMetadata actual) {
    return new io.fabric8.kubernetes.api.model.HasMetadataAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesKindAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesKindAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesKind actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesKindAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResource actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleFluentAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleFluent actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaAssert assertThat(io.fabric8.kubernetes.api.model.ListMeta actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ListMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ListMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceAssert assertThat(io.fabric8.kubernetes.api.model.Namespace actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAssert assertThat(io.fabric8.kubernetes.api.model.Node actual) {
    return new io.fabric8.kubernetes.api.model.NodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddressFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListAssert assertThat(io.fabric8.kubernetes.api.model.NodeList actual) {
    return new io.fabric8.kubernetes.api.model.NodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeListFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReferenceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReferenceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionAssert assertThat(io.fabric8.kubernetes.api.model.PodCondition actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusAssert assertThat(io.fabric8.kubernetes.api.model.PodStatus actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeAssert assertThat(io.fabric8.kubernetes.api.model.Probe actual) {
    return new io.fabric8.kubernetes.api.model.ProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ProbeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ProbeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeFluentAssert assertThat(io.fabric8.kubernetes.api.model.ProbeFluent actual) {
    return new io.fabric8.kubernetes.api.model.ProbeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretAssert assertThat(io.fabric8.kubernetes.api.model.Secret actual) {
    return new io.fabric8.kubernetes.api.model.SecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListAssert assertThat(io.fabric8.kubernetes.api.model.SecretList actual) {
    return new io.fabric8.kubernetes.api.model.SecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretListFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortAssert assertThat(io.fabric8.kubernetes.api.model.ServicePort actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServicePortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServicePortFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ListMetaAssert assertThat(io.fabric8.kubernetes.api.model.base.ListMeta actual) {
    return new io.fabric8.kubernetes.api.model.base.ListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ListMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ListMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.base.ListMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.base.ListMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ListMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ListMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.base.ListMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.base.ListMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusAssert assertThat(io.fabric8.kubernetes.api.model.base.Status actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusCauseBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusCauseBuilderAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusCauseBuilder actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusCauseBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusCauseFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusCauseFluentAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusCauseFluent actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusCauseFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusDetailsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusDetailsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusDetailsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusDetailsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusDetailsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusDetailsFluentAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusDetailsFluent actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusDetailsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.AuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.AuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.config.AuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.config.AuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.ClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.ClusterAssert assertThat(io.fabric8.kubernetes.api.model.config.Cluster actual) {
    return new io.fabric8.kubernetes.api.model.config.ClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.ConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.ConfigAssert assertThat(io.fabric8.kubernetes.api.model.config.Config actual) {
    return new io.fabric8.kubernetes.api.model.config.ConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.ContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.ContextAssert assertThat(io.fabric8.kubernetes.api.model.config.Context actual) {
    return new io.fabric8.kubernetes.api.model.config.ContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.NamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.NamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.config.NamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.config.NamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.NamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.NamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.config.NamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.config.NamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.NamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.NamedContextAssert assertThat(io.fabric8.kubernetes.api.model.config.NamedContext actual) {
    return new io.fabric8.kubernetes.api.model.config.NamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.NamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.NamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.config.NamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.config.NamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.config.PreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.config.PreferencesAssert assertThat(io.fabric8.kubernetes.api.model.config.Preferences actual) {
    return new io.fabric8.kubernetes.api.model.config.PreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.errors.StatusErrorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.errors.StatusErrorAssert assertThat(io.fabric8.kubernetes.api.model.errors.StatusError actual) {
    return new io.fabric8.kubernetes.api.model.errors.StatusErrorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.resource.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityBuilderAssert assertThat(io.fabric8.kubernetes.api.model.resource.QuantityBuilder actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityFluentAssert assertThat(io.fabric8.kubernetes.api.model.resource.QuantityFluent actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringBuilderAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrStringBuilder actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringFluentAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrStringFluent actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringFluentAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
