package io.fabric8.kubernetes.api.model.util;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IntOrString} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIntOrStringAssert<S extends AbstractIntOrStringAssert<S, A>, A extends IntOrString> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIntOrStringAssert}</code> to make assertions on actual IntOrString.
   * @param actual the IntOrString we want to make assertions on.
   */
  protected AbstractIntOrStringAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IntOrString's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IntOrString's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IntOrString's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IntOrString's intVal is equal to the given one.
   * @param intVal the given intVal to compare the actual IntOrString's intVal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IntOrString's intVal is not equal to the given one.
   */
  public S hasIntVal(Integer intVal) {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected intVal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualIntVal = actual.getIntVal();
    if (!Objects.areEqual(actualIntVal, intVal)) {
      failWithMessage(assertjErrorMessage, actual, intVal, actualIntVal);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IntOrString's kind is equal to the given one.
   * @param kind the given kind to compare the actual IntOrString's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IntOrString's kind is not equal to the given one.
   */
  public S hasKind(Integer kind) {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IntOrString's strVal is equal to the given one.
   * @param strVal the given strVal to compare the actual IntOrString's strVal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IntOrString's strVal is not equal to the given one.
   */
  public S hasStrVal(String strVal) {
    // check that actual IntOrString we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected strVal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStrVal = actual.getStrVal();
    if (!Objects.areEqual(actualStrVal, strVal)) {
      failWithMessage(assertjErrorMessage, actual, strVal, actualStrVal);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
