package io.fabric8.kubernetes.api.model.config;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Preferences} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPreferencesAssert<S extends AbstractPreferencesAssert<S, A>, A extends Preferences> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPreferencesAssert}</code> to make assertions on actual Preferences.
   * @param actual the Preferences we want to make assertions on.
   */
  protected AbstractPreferencesAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Preferences's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Preferences's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Preferences's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Preferences we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Preferences's colors is equal to the given one.
   * @param colors the given colors to compare the actual Preferences's colors to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Preferences's colors is not equal to the given one.
   */
  public S hasColors(Boolean colors) {
    // check that actual Preferences we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected colors of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualColors = actual.getColors();
    if (!Objects.areEqual(actualColors, colors)) {
      failWithMessage(assertjErrorMessage, actual, colors, actualColors);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Preferences's extensions contains the given NamedExtension elements.
   * @param extensions the given elements that should be contained in actual Preferences's extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual Preferences's extensions does not contain all given NamedExtension elements.
   */
  public S hasExtensions(NamedExtension... extensions) {
    // check that actual Preferences we want to make assertions on is not null.
    isNotNull();

    // check that given NamedExtension varargs is not null.
    if (extensions == null) throw new AssertionError("Expecting extensions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getExtensions(), extensions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Preferences has no extensions.
   * @return this assertion object.
   * @throws AssertionError if the actual Preferences's extensions is not empty.
   */
  public S hasNoExtensions() {
    // check that actual Preferences we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
    
    // check
    if (actual.getExtensions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getExtensions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
