package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EndpointAddressFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointAddressFluentAssert<S extends AbstractEndpointAddressFluentAssert<S, A>, A extends EndpointAddressFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointAddressFluentAssert}</code> to make assertions on actual EndpointAddressFluent.
   * @param actual the EndpointAddressFluent we want to make assertions on.
   */
  protected AbstractEndpointAddressFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EndpointAddressFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EndpointAddressFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EndpointAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointAddressFluent's iP is equal to the given one.
   * @param iP the given iP to compare the actual EndpointAddressFluent's iP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluent's iP is not equal to the given one.
   */
  public S hasIP(String iP) {
    // check that actual EndpointAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected iP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIP = actual.getIP();
    if (!Objects.areEqual(actualIP, iP)) {
      failWithMessage(assertjErrorMessage, actual, iP, actualIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointAddressFluent's targetRef is equal to the given one.
   * @param targetRef the given targetRef to compare the actual EndpointAddressFluent's targetRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointAddressFluent's targetRef is not equal to the given one.
   */
  public S hasTargetRef(ObjectReference targetRef) {
    // check that actual EndpointAddressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected targetRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectReference actualTargetRef = actual.getTargetRef();
    if (!Objects.areEqual(actualTargetRef, targetRef)) {
      failWithMessage(assertjErrorMessage, actual, targetRef, actualTargetRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
