/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent;
import java.util.HashMap;
import java.util.Map;

public class VolumeFluent<T extends VolumeFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    EmptyDirVolumeSourceBuilder emptyDir;
    GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
    GitRepoVolumeSourceBuilder gitRepo;
    GlusterfsVolumeSourceBuilder glusterfs;
    HostPathVolumeSourceBuilder hostPath;
    ISCSIVolumeSourceBuilder iscsi;
    String name;
    NFSVolumeSourceBuilder nfs;
    SecretVolumeSourceBuilder secret;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir != null ? this.emptyDir.build() : null;
    }

    public T withEmptyDir(EmptyDirVolumeSource emptyDir) {
        if (emptyDir != null) {
            this.emptyDir = new EmptyDirVolumeSourceBuilder(emptyDir);
            this._visitables.add(this.emptyDir);
        }
        return (T)((Object)this);
    }

    public EmptyDirNested<T> withNewEmptyDir() {
        return new EmptyDirNested();
    }

    public T withNewEmptyDir(String medium) {
        return this.withEmptyDir(new EmptyDirVolumeSource(medium));
    }

    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? this.gcePersistentDisk.build() : null;
    }

    public T withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (T)((Object)this);
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDisk() {
        return new GcePersistentDiskNested();
    }

    public T withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public GitRepoVolumeSource getGitRepo() {
        return this.gitRepo != null ? this.gitRepo.build() : null;
    }

    public T withGitRepo(GitRepoVolumeSource gitRepo) {
        if (gitRepo != null) {
            this.gitRepo = new GitRepoVolumeSourceBuilder(gitRepo);
            this._visitables.add(this.gitRepo);
        }
        return (T)((Object)this);
    }

    public GitRepoNested<T> withNewGitRepo() {
        return new GitRepoNested();
    }

    public T withNewGitRepo(String repository, String revision) {
        return this.withGitRepo(new GitRepoVolumeSource(repository, revision));
    }

    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? this.glusterfs.build() : null;
    }

    public T withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (T)((Object)this);
    }

    public GlusterfsNested<T> withNewGlusterfs() {
        return new GlusterfsNested();
    }

    public T withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? this.hostPath.build() : null;
    }

    public T withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (T)((Object)this);
    }

    public HostPathNested<T> withNewHostPath() {
        return new HostPathNested();
    }

    public T withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? this.iscsi.build() : null;
    }

    public T withIscsi(ISCSIVolumeSource iscsi) {
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (T)((Object)this);
    }

    public IscsiNested<T> withNewIscsi() {
        return new IscsiNested();
    }

    public T withNewIscsi(String fsType, String iqn, Integer lun, Boolean readOnly, String targetPortal) {
        return this.withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)((Object)this);
    }

    public NFSVolumeSource getNfs() {
        return this.nfs != null ? this.nfs.build() : null;
    }

    public T withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (T)((Object)this);
    }

    public NfsNested<T> withNewNfs() {
        return new NfsNested();
    }

    public T withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public SecretVolumeSource getSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    public T withSecret(SecretVolumeSource secret) {
        if (secret != null) {
            this.secret = new SecretVolumeSourceBuilder(secret);
            this._visitables.add(this.secret);
        }
        return (T)((Object)this);
    }

    public SecretNested<T> withNewSecret() {
        return new SecretNested();
    }

    public T withNewSecret(String secretName) {
        return this.withSecret(new SecretVolumeSource(secretName));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class SecretNested<N>
    extends SecretVolumeSourceFluent<SecretNested<N>>
    implements Nested<N> {
        private final SecretVolumeSourceBuilder builder = new SecretVolumeSourceBuilder(this);

        public N and() {
            return (N)VolumeFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class NfsNested<N>
    extends NFSVolumeSourceFluent<NfsNested<N>>
    implements Nested<N> {
        private final NFSVolumeSourceBuilder builder = new NFSVolumeSourceBuilder(this);

        public N endNfs() {
            return this.and();
        }

        public N and() {
            return (N)VolumeFluent.this.withNfs(this.builder.build());
        }
    }

    public class IscsiNested<N>
    extends ISCSIVolumeSourceFluent<IscsiNested<N>>
    implements Nested<N> {
        private final ISCSIVolumeSourceBuilder builder = new ISCSIVolumeSourceBuilder(this);

        public N endIscsi() {
            return this.and();
        }

        public N and() {
            return (N)VolumeFluent.this.withIscsi(this.builder.build());
        }
    }

    public class HostPathNested<N>
    extends HostPathVolumeSourceFluent<HostPathNested<N>>
    implements Nested<N> {
        private final HostPathVolumeSourceBuilder builder = new HostPathVolumeSourceBuilder(this);

        public N endHostPath() {
            return this.and();
        }

        public N and() {
            return (N)VolumeFluent.this.withHostPath(this.builder.build());
        }
    }

    public class GlusterfsNested<N>
    extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>>
    implements Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder = new GlusterfsVolumeSourceBuilder(this);

        public N endGlusterfs() {
            return this.and();
        }

        public N and() {
            return (N)VolumeFluent.this.withGlusterfs(this.builder.build());
        }
    }

    public class GitRepoNested<N>
    extends GitRepoVolumeSourceFluent<GitRepoNested<N>>
    implements Nested<N> {
        private final GitRepoVolumeSourceBuilder builder = new GitRepoVolumeSourceBuilder(this);

        public N and() {
            return (N)VolumeFluent.this.withGitRepo(this.builder.build());
        }

        public N endGitRepo() {
            return this.and();
        }
    }

    public class GcePersistentDiskNested<N>
    extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>
    implements Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder = new GCEPersistentDiskVolumeSourceBuilder(this);

        public N and() {
            return (N)VolumeFluent.this.withGcePersistentDisk(this.builder.build());
        }

        public N endGcePersistentDisk() {
            return this.and();
        }
    }

    public class EmptyDirNested<N>
    extends EmptyDirVolumeSourceFluent<EmptyDirNested<N>>
    implements Nested<N> {
        private final EmptyDirVolumeSourceBuilder builder = new EmptyDirVolumeSourceBuilder(this);

        public N endEmptyDir() {
            return this.and();
        }

        public N and() {
            return (N)VolumeFluent.this.withEmptyDir(this.builder.build());
        }
    }
}

