/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractServiceSpecFluentAssert<S extends AbstractServiceSpecFluentAssert<S, A>, A extends ServiceSpecFluent>
extends AbstractAssert<S, A> {
    protected AbstractServiceSpecFluentAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ServiceSpecFluent)((Object)this.actual)).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasPortalIP(String portalIP) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected portalIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPortalIP = ((ServiceSpecFluent)((Object)this.actual)).getPortalIP();
        if (!Objects.areEqual((Object)actualPortalIP, (Object)portalIP)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, portalIP, actualPortalIP});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasPorts(ServicePort ... ports) {
        this.isNotNull();
        if (ports == null) {
            throw new AssertionError((Object)"Expecting ports parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceSpecFluent)((Object)this.actual)).getPorts(), (Object[])ports);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasNoPorts() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have ports but had :\n  <%s>";
        if (((ServiceSpecFluent)((Object)this.actual)).getPorts().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceSpecFluent)((Object)this.actual)).getPorts()});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasPublicIPs(String ... publicIPs) {
        this.isNotNull();
        if (publicIPs == null) {
            throw new AssertionError((Object)"Expecting publicIPs parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceSpecFluent)((Object)this.actual)).getPublicIPs(), (Object[])publicIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasNoPublicIPs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have publicIPs but had :\n  <%s>";
        if (((ServiceSpecFluent)((Object)this.actual)).getPublicIPs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceSpecFluent)((Object)this.actual)).getPublicIPs()});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasSelector(Map selector) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualSelector = ((ServiceSpecFluent)((Object)this.actual)).getSelector();
        if (!Objects.areEqual(actualSelector, (Object)selector)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, selector, actualSelector});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasSessionAffinity(String sessionAffinity) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected sessionAffinity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSessionAffinity = ((ServiceSpecFluent)((Object)this.actual)).getSessionAffinity();
        if (!Objects.areEqual((Object)actualSessionAffinity, (Object)sessionAffinity)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sessionAffinity, actualSessionAffinity});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }
}

