package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServicePortFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServicePortFluentAssert<S extends AbstractServicePortFluentAssert<S, A>, A extends ServicePortFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServicePortFluentAssert}</code> to make assertions on actual ServicePortFluent.
   * @param actual the ServicePortFluent we want to make assertions on.
   */
  protected AbstractServicePortFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServicePortFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServicePortFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServicePortFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServicePortFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServicePortFluent's name is equal to the given one.
   * @param name the given name to compare the actual ServicePortFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServicePortFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ServicePortFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServicePortFluent's port is equal to the given one.
   * @param port the given port to compare the actual ServicePortFluent's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServicePortFluent's port is not equal to the given one.
   */
  public S hasPort(Integer port) {
    // check that actual ServicePortFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServicePortFluent's protocol is equal to the given one.
   * @param protocol the given protocol to compare the actual ServicePortFluent's protocol to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServicePortFluent's protocol is not equal to the given one.
   */
  public S hasProtocol(String protocol) {
    // check that actual ServicePortFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected protocol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProtocol = actual.getProtocol();
    if (!Objects.areEqual(actualProtocol, protocol)) {
      failWithMessage(assertjErrorMessage, actual, protocol, actualProtocol);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServicePortFluent's targetPort is equal to the given one.
   * @param targetPort the given targetPort to compare the actual ServicePortFluent's targetPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServicePortFluent's targetPort is not equal to the given one.
   */
  public S hasTargetPort(io.fabric8.kubernetes.api.model.util.IntOrString targetPort) {
    // check that actual ServicePortFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected targetPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.util.IntOrString actualTargetPort = actual.getTargetPort();
    if (!Objects.areEqual(actualTargetPort, targetPort)) {
      failWithMessage(assertjErrorMessage, actual, targetPort, actualTargetPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
