package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSpecAssert<S extends AbstractPodSpecAssert<S, A>, A extends PodSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSpecAssert}</code> to make assertions on actual PodSpec.
   * @param actual the PodSpec we want to make assertions on.
   */
  protected AbstractPodSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec's containers contains the given Container elements.
   * @param containers the given elements that should be contained in actual PodSpec's containers.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpec's containers does not contain all given Container elements.
   */
  public S hasContainers(Container... containers) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given Container varargs is not null.
    if (containers == null) throw new AssertionError("Expecting containers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContainers(), containers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec has no containers.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpec's containers is not empty.
   */
  public S hasNoContainers() {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
    
    // check
    if (actual.getContainers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContainers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodSpec's dnsPolicy is equal to the given one.
   * @param dnsPolicy the given dnsPolicy to compare the actual PodSpec's dnsPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's dnsPolicy is not equal to the given one.
   */
  public S hasDnsPolicy(String dnsPolicy) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected dnsPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDnsPolicy = actual.getDnsPolicy();
    if (!Objects.areEqual(actualDnsPolicy, dnsPolicy)) {
      failWithMessage(assertjErrorMessage, actual, dnsPolicy, actualDnsPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec's host is equal to the given one.
   * @param host the given host to compare the actual PodSpec's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec's hostNetwork is equal to the given one.
   * @param hostNetwork the given hostNetwork to compare the actual PodSpec's hostNetwork to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's hostNetwork is not equal to the given one.
   */
  public S hasHostNetwork(Boolean hostNetwork) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostNetwork of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualHostNetwork = actual.getHostNetwork();
    if (!Objects.areEqual(actualHostNetwork, hostNetwork)) {
      failWithMessage(assertjErrorMessage, actual, hostNetwork, actualHostNetwork);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec's nodeSelector is equal to the given one.
   * @param nodeSelector the given nodeSelector to compare the actual PodSpec's nodeSelector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's nodeSelector is not equal to the given one.
   */
  public S hasNodeSelector(java.util.Map nodeSelector) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualNodeSelector = actual.getNodeSelector();
    if (!Objects.areEqual(actualNodeSelector, nodeSelector)) {
      failWithMessage(assertjErrorMessage, actual, nodeSelector, actualNodeSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec's restartPolicy is equal to the given one.
   * @param restartPolicy the given restartPolicy to compare the actual PodSpec's restartPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSpec's restartPolicy is not equal to the given one.
   */
  public S hasRestartPolicy(String restartPolicy) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected restartPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRestartPolicy = actual.getRestartPolicy();
    if (!Objects.areEqual(actualRestartPolicy, restartPolicy)) {
      failWithMessage(assertjErrorMessage, actual, restartPolicy, actualRestartPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec's volumes contains the given Volume elements.
   * @param volumes the given elements that should be contained in actual PodSpec's volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpec's volumes does not contain all given Volume elements.
   */
  public S hasVolumes(Volume... volumes) {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // check that given Volume varargs is not null.
    if (volumes == null) throw new AssertionError("Expecting volumes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumes(), volumes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSpec has no volumes.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSpec's volumes is not empty.
   */
  public S hasNoVolumes() {
    // check that actual PodSpec we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
    
    // check
    if (actual.getVolumes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
