package io.fabric8.kubernetes.api.model;

import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link KubernetesList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesListAssert<S extends AbstractKubernetesListAssert<S, A>, A extends KubernetesList> extends AbstractBaseKubernetesListAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesListAssert}</code> to make assertions on actual KubernetesList.
   * @param actual the KubernetesList we want to make assertions on.
   */
  protected AbstractKubernetesListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubernetesList's buildConfigs contains the given io.fabric8.openshift.api.model.BuildConfig elements.
   * @param buildConfigs the given elements that should be contained in actual KubernetesList's buildConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's buildConfigs does not contain all given io.fabric8.openshift.api.model.BuildConfig elements.
   */
  public S hasBuildConfigs(io.fabric8.openshift.api.model.BuildConfig... buildConfigs) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.BuildConfig varargs is not null.
    if (buildConfigs == null) throw new AssertionError("Expecting buildConfigs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getBuildConfigs(), buildConfigs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no buildConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's buildConfigs is not empty.
   */
  public S hasNoBuildConfigs() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have buildConfigs but had :\n  <%s>";
    
    // check
    if (actual.getBuildConfigs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getBuildConfigs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's deploymentConfigs contains the given io.fabric8.openshift.api.model.DeploymentConfig elements.
   * @param deploymentConfigs the given elements that should be contained in actual KubernetesList's deploymentConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's deploymentConfigs does not contain all given io.fabric8.openshift.api.model.DeploymentConfig elements.
   */
  public S hasDeploymentConfigs(io.fabric8.openshift.api.model.DeploymentConfig... deploymentConfigs) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.DeploymentConfig varargs is not null.
    if (deploymentConfigs == null) throw new AssertionError("Expecting deploymentConfigs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDeploymentConfigs(), deploymentConfigs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no deploymentConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's deploymentConfigs is not empty.
   */
  public S hasNoDeploymentConfigs() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have deploymentConfigs but had :\n  <%s>";
    
    // check
    if (actual.getDeploymentConfigs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getDeploymentConfigs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's imageStreams contains the given io.fabric8.openshift.api.model.ImageStream elements.
   * @param imageStreams the given elements that should be contained in actual KubernetesList's imageStreams.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's imageStreams does not contain all given io.fabric8.openshift.api.model.ImageStream elements.
   */
  public S hasImageStreams(io.fabric8.openshift.api.model.ImageStream... imageStreams) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.ImageStream varargs is not null.
    if (imageStreams == null) throw new AssertionError("Expecting imageStreams parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImageStreams(), imageStreams);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no imageStreams.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's imageStreams is not empty.
   */
  public S hasNoImageStreams() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have imageStreams but had :\n  <%s>";
    
    // check
    if (actual.getImageStreams().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImageStreams());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's pods contains the given Pod elements.
   * @param pods the given elements that should be contained in actual KubernetesList's pods.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's pods does not contain all given Pod elements.
   */
  public S hasPods(Pod... pods) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given Pod varargs is not null.
    if (pods == null) throw new AssertionError("Expecting pods parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPods(), pods);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no pods.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's pods is not empty.
   */
  public S hasNoPods() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have pods but had :\n  <%s>";
    
    // check
    if (actual.getPods().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPods());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's replicationControllers contains the given ReplicationController elements.
   * @param replicationControllers the given elements that should be contained in actual KubernetesList's replicationControllers.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's replicationControllers does not contain all given ReplicationController elements.
   */
  public S hasReplicationControllers(ReplicationController... replicationControllers) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicationController varargs is not null.
    if (replicationControllers == null) throw new AssertionError("Expecting replicationControllers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getReplicationControllers(), replicationControllers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no replicationControllers.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's replicationControllers is not empty.
   */
  public S hasNoReplicationControllers() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have replicationControllers but had :\n  <%s>";
    
    // check
    if (actual.getReplicationControllers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getReplicationControllers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's routes contains the given io.fabric8.openshift.api.model.Route elements.
   * @param routes the given elements that should be contained in actual KubernetesList's routes.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's routes does not contain all given io.fabric8.openshift.api.model.Route elements.
   */
  public S hasRoutes(io.fabric8.openshift.api.model.Route... routes) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.Route varargs is not null.
    if (routes == null) throw new AssertionError("Expecting routes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRoutes(), routes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no routes.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's routes is not empty.
   */
  public S hasNoRoutes() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have routes but had :\n  <%s>";
    
    // check
    if (actual.getRoutes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRoutes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's services contains the given Service elements.
   * @param services the given elements that should be contained in actual KubernetesList's services.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's services does not contain all given Service elements.
   */
  public S hasServices(Service... services) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given Service varargs is not null.
    if (services == null) throw new AssertionError("Expecting services parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getServices(), services);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no services.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's services is not empty.
   */
  public S hasNoServices() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have services but had :\n  <%s>";
    
    // check
    if (actual.getServices().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getServices());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesList's templates contains the given io.fabric8.openshift.api.model.template.Template elements.
   * @param templates the given elements that should be contained in actual KubernetesList's templates.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's templates does not contain all given io.fabric8.openshift.api.model.template.Template elements.
   */
  public S hasTemplates(io.fabric8.openshift.api.model.template.Template... templates) {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.template.Template varargs is not null.
    if (templates == null) throw new AssertionError("Expecting templates parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTemplates(), templates);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesList has no templates.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesList's templates is not empty.
   */
  public S hasNoTemplates() {
    // check that actual KubernetesList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have templates but had :\n  <%s>";
    
    // check
    if (actual.getTemplates().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTemplates());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
