/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.AbstractBaseKubernetesListAssert;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.template.Template;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

public abstract class AbstractKubernetesListAssert<S extends AbstractKubernetesListAssert<S, A>, A extends KubernetesList>
extends AbstractBaseKubernetesListAssert<S, A> {
    protected AbstractKubernetesListAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasBuildConfigs(BuildConfig ... buildConfigs) {
        this.isNotNull();
        if (buildConfigs == null) {
            throw new AssertionError((Object)"Expecting buildConfigs parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getBuildConfigs(), (Object[])buildConfigs);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoBuildConfigs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have buildConfigs but had :\n  <%s>";
        if (((KubernetesList)this.actual).getBuildConfigs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getBuildConfigs()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasDeploymentConfigs(DeploymentConfig ... deploymentConfigs) {
        this.isNotNull();
        if (deploymentConfigs == null) {
            throw new AssertionError((Object)"Expecting deploymentConfigs parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getDeploymentConfigs(), (Object[])deploymentConfigs);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoDeploymentConfigs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have deploymentConfigs but had :\n  <%s>";
        if (((KubernetesList)this.actual).getDeploymentConfigs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getDeploymentConfigs()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasImageStreams(ImageStream ... imageStreams) {
        this.isNotNull();
        if (imageStreams == null) {
            throw new AssertionError((Object)"Expecting imageStreams parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getImageStreams(), (Object[])imageStreams);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoImageStreams() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have imageStreams but had :\n  <%s>";
        if (((KubernetesList)this.actual).getImageStreams().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getImageStreams()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasPods(Pod ... pods) {
        this.isNotNull();
        if (pods == null) {
            throw new AssertionError((Object)"Expecting pods parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getPods(), (Object[])pods);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoPods() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have pods but had :\n  <%s>";
        if (((KubernetesList)this.actual).getPods().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getPods()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasReplicationControllers(ReplicationController ... replicationControllers) {
        this.isNotNull();
        if (replicationControllers == null) {
            throw new AssertionError((Object)"Expecting replicationControllers parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getReplicationControllers(), (Object[])replicationControllers);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoReplicationControllers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have replicationControllers but had :\n  <%s>";
        if (((KubernetesList)this.actual).getReplicationControllers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getReplicationControllers()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasRoutes(Route ... routes) {
        this.isNotNull();
        if (routes == null) {
            throw new AssertionError((Object)"Expecting routes parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getRoutes(), (Object[])routes);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoRoutes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have routes but had :\n  <%s>";
        if (((KubernetesList)this.actual).getRoutes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getRoutes()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasServices(Service ... services) {
        this.isNotNull();
        if (services == null) {
            throw new AssertionError((Object)"Expecting services parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getServices(), (Object[])services);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoServices() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have services but had :\n  <%s>";
        if (((KubernetesList)this.actual).getServices().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getServices()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasTemplates(Template ... templates) {
        this.isNotNull();
        if (templates == null) {
            throw new AssertionError((Object)"Expecting templates parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((KubernetesList)this.actual).getTemplates(), (Object[])templates);
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }

    public S hasNoTemplates() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have templates but had :\n  <%s>";
        if (((KubernetesList)this.actual).getTemplates().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((KubernetesList)this.actual).getTemplates()});
        }
        return (S)((Object)((AbstractKubernetesListAssert)this.myself));
    }
}

