package io.fabric8.kubernetes.api.model.base;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GCEPersistentDiskVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGCEPersistentDiskVolumeSourceAssert<S extends AbstractGCEPersistentDiskVolumeSourceAssert<S, A>, A extends GCEPersistentDiskVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGCEPersistentDiskVolumeSourceAssert}</code> to make assertions on actual GCEPersistentDiskVolumeSource.
   * @param actual the GCEPersistentDiskVolumeSource we want to make assertions on.
   */
  protected AbstractGCEPersistentDiskVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GCEPersistentDiskVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GCEPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSource's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual GCEPersistentDiskVolumeSource's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSource's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual GCEPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSource's partition is equal to the given one.
   * @param partition the given partition to compare the actual GCEPersistentDiskVolumeSource's partition to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSource's partition is not equal to the given one.
   */
  public S hasPartition(Integer partition) {
    // check that actual GCEPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected partition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPartition = actual.getPartition();
    if (!Objects.areEqual(actualPartition, partition)) {
      failWithMessage(assertjErrorMessage, actual, partition, actualPartition);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSource's pdName is equal to the given one.
   * @param pdName the given pdName to compare the actual GCEPersistentDiskVolumeSource's pdName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSource's pdName is not equal to the given one.
   */
  public S hasPdName(String pdName) {
    // check that actual GCEPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected pdName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPdName = actual.getPdName();
    if (!Objects.areEqual(actualPdName, pdName)) {
      failWithMessage(assertjErrorMessage, actual, pdName, actualPdName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSource's readOnly is equal to the given one.
   * @param readOnly the given readOnly to compare the actual GCEPersistentDiskVolumeSource's readOnly to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSource's readOnly is not equal to the given one.
   */
  public S hasReadOnly(Boolean readOnly) {
    // check that actual GCEPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected readOnly of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReadOnly = actual.getReadOnly();
    if (!Objects.areEqual(actualReadOnly, readOnly)) {
      failWithMessage(assertjErrorMessage, actual, readOnly, actualReadOnly);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
