package io.fabric8.kubernetes.api.model.base;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerPort} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerPortAssert<S extends AbstractContainerPortAssert<S, A>, A extends ContainerPort> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerPortAssert}</code> to make assertions on actual ContainerPort.
   * @param actual the ContainerPort we want to make assertions on.
   */
  protected AbstractContainerPortAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerPort's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerPort's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerPort's containerPort is equal to the given one.
   * @param containerPort the given containerPort to compare the actual ContainerPort's containerPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's containerPort is not equal to the given one.
   */
  public S hasContainerPort(Integer containerPort) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected containerPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualContainerPort = actual.getContainerPort();
    if (!Objects.areEqual(actualContainerPort, containerPort)) {
      failWithMessage(assertjErrorMessage, actual, containerPort, actualContainerPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerPort's hostIP is equal to the given one.
   * @param hostIP the given hostIP to compare the actual ContainerPort's hostIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's hostIP is not equal to the given one.
   */
  public S hasHostIP(String hostIP) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHostIP = actual.getHostIP();
    if (!Objects.areEqual(actualHostIP, hostIP)) {
      failWithMessage(assertjErrorMessage, actual, hostIP, actualHostIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerPort's hostPort is equal to the given one.
   * @param hostPort the given hostPort to compare the actual ContainerPort's hostPort to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's hostPort is not equal to the given one.
   */
  public S hasHostPort(Integer hostPort) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualHostPort = actual.getHostPort();
    if (!Objects.areEqual(actualHostPort, hostPort)) {
      failWithMessage(assertjErrorMessage, actual, hostPort, actualHostPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerPort's name is equal to the given one.
   * @param name the given name to compare the actual ContainerPort's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerPort's protocol is equal to the given one.
   * @param protocol the given protocol to compare the actual ContainerPort's protocol to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerPort's protocol is not equal to the given one.
   */
  public S hasProtocol(String protocol) {
    // check that actual ContainerPort we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected protocol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProtocol = actual.getProtocol();
    if (!Objects.areEqual(actualProtocol, protocol)) {
      failWithMessage(assertjErrorMessage, actual, protocol, actualProtocol);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
