package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeSourceFluentAssert<S extends AbstractVolumeSourceFluentAssert<S, A>, A extends VolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeSourceFluentAssert}</code> to make assertions on actual VolumeSourceFluent.
   * @param actual the VolumeSourceFluent we want to make assertions on.
   */
  protected AbstractVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual VolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's emptyDir is equal to the given one.
   * @param emptyDir the given emptyDir to compare the actual VolumeSourceFluent's emptyDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's emptyDir is not equal to the given one.
   */
  public S hasEmptyDir(EmptyDirVolumeSource emptyDir) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected emptyDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EmptyDirVolumeSource actualEmptyDir = actual.getEmptyDir();
    if (!Objects.areEqual(actualEmptyDir, emptyDir)) {
      failWithMessage(assertjErrorMessage, actual, emptyDir, actualEmptyDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's gitRepo is equal to the given one.
   * @param gitRepo the given gitRepo to compare the actual VolumeSourceFluent's gitRepo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's gitRepo is not equal to the given one.
   */
  public S hasGitRepo(GitRepoVolumeSource gitRepo) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected gitRepo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitRepoVolumeSource actualGitRepo = actual.getGitRepo();
    if (!Objects.areEqual(actualGitRepo, gitRepo)) {
      failWithMessage(assertjErrorMessage, actual, gitRepo, actualGitRepo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's glusterfs is equal to the given one.
   * @param glusterfs the given glusterfs to compare the actual VolumeSourceFluent's glusterfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's glusterfs is not equal to the given one.
   */
  public S hasGlusterfs(GlusterfsVolumeSource glusterfs) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected glusterfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GlusterfsVolumeSource actualGlusterfs = actual.getGlusterfs();
    if (!Objects.areEqual(actualGlusterfs, glusterfs)) {
      failWithMessage(assertjErrorMessage, actual, glusterfs, actualGlusterfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's hostDir is equal to the given one.
   * @param hostDir the given hostDir to compare the actual VolumeSourceFluent's hostDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's hostDir is not equal to the given one.
   */
  public S hasHostDir(HostPathVolumeSource hostDir) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HostPathVolumeSource actualHostDir = actual.getHostDir();
    if (!Objects.areEqual(actualHostDir, hostDir)) {
      failWithMessage(assertjErrorMessage, actual, hostDir, actualHostDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's iscsi is equal to the given one.
   * @param iscsi the given iscsi to compare the actual VolumeSourceFluent's iscsi to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's iscsi is not equal to the given one.
   */
  public S hasIscsi(ISCSIVolumeSource iscsi) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected iscsi of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ISCSIVolumeSource actualIscsi = actual.getIscsi();
    if (!Objects.areEqual(actualIscsi, iscsi)) {
      failWithMessage(assertjErrorMessage, actual, iscsi, actualIscsi);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's nfs is equal to the given one.
   * @param nfs the given nfs to compare the actual VolumeSourceFluent's nfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's nfs is not equal to the given one.
   */
  public S hasNfs(NFSVolumeSource nfs) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NFSVolumeSource actualNfs = actual.getNfs();
    if (!Objects.areEqual(actualNfs, nfs)) {
      failWithMessage(assertjErrorMessage, actual, nfs, actualNfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's persistentDisk is equal to the given one.
   * @param persistentDisk the given persistentDisk to compare the actual VolumeSourceFluent's persistentDisk to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's persistentDisk is not equal to the given one.
   */
  public S hasPersistentDisk(GCEPersistentDiskVolumeSource persistentDisk) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentDisk of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GCEPersistentDiskVolumeSource actualPersistentDisk = actual.getPersistentDisk();
    if (!Objects.areEqual(actualPersistentDisk, persistentDisk)) {
      failWithMessage(assertjErrorMessage, actual, persistentDisk, actualPersistentDisk);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSourceFluent's secret is equal to the given one.
   * @param secret the given secret to compare the actual VolumeSourceFluent's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSourceFluent's secret is not equal to the given one.
   */
  public S hasSecret(SecretVolumeSource secret) {
    // check that actual VolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecretVolumeSource actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
