package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ReplicationControllerList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicationControllerListAssert<S extends AbstractReplicationControllerListAssert<S, A>, A extends ReplicationControllerList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicationControllerListAssert}</code> to make assertions on actual ReplicationControllerList.
   * @param actual the ReplicationControllerList we want to make assertions on.
   */
  protected AbstractReplicationControllerListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ReplicationControllerList's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ReplicationControllerList's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual ReplicationControllerList's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ReplicationControllerList's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ReplicationControllerList.ApiVersion apiVersion) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerList.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual ReplicationControllerList's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's deletionTimestamp is equal to the given one.
   * @param deletionTimestamp the given deletionTimestamp to compare the actual ReplicationControllerList's deletionTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's deletionTimestamp is not equal to the given one.
   */
  public S hasDeletionTimestamp(String deletionTimestamp) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deletionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDeletionTimestamp = actual.getDeletionTimestamp();
    if (!Objects.areEqual(actualDeletionTimestamp, deletionTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, deletionTimestamp, actualDeletionTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's generateName is equal to the given one.
   * @param generateName the given generateName to compare the actual ReplicationControllerList's generateName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's generateName is not equal to the given one.
   */
  public S hasGenerateName(String generateName) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected generateName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerateName = actual.getGenerateName();
    if (!Objects.areEqual(actualGenerateName, generateName)) {
      failWithMessage(assertjErrorMessage, actual, generateName, actualGenerateName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's id is equal to the given one.
   * @param id the given id to compare the actual ReplicationControllerList's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's items contains the given ReplicationController elements.
   * @param items the given elements that should be contained in actual ReplicationControllerList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicationControllerList's items does not contain all given ReplicationController elements.
   */
  public S hasItems(ReplicationController... items) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicationController varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicationControllerList's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ReplicationControllerList's kind is equal to the given one.
   * @param kind the given kind to compare the actual ReplicationControllerList's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual ReplicationControllerList's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual ReplicationControllerList's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual ReplicationControllerList's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicationControllerList's uid is equal to the given one.
   * @param uid the given uid to compare the actual ReplicationControllerList's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicationControllerList's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual ReplicationControllerList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
