package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Pod} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodAssert<S extends AbstractPodAssert<S, A>, A extends Pod> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodAssert}</code> to make assertions on actual Pod.
   * @param actual the Pod we want to make assertions on.
   */
  protected AbstractPodAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Pod's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Pod's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual Pod's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Pod's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Pod.ApiVersion apiVersion) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Pod.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual Pod's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's currentState is equal to the given one.
   * @param currentState the given currentState to compare the actual Pod's currentState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's currentState is not equal to the given one.
   */
  public S hasCurrentState(PodState currentState) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected currentState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodState actualCurrentState = actual.getCurrentState();
    if (!Objects.areEqual(actualCurrentState, currentState)) {
      failWithMessage(assertjErrorMessage, actual, currentState, actualCurrentState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's deletionTimestamp is equal to the given one.
   * @param deletionTimestamp the given deletionTimestamp to compare the actual Pod's deletionTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's deletionTimestamp is not equal to the given one.
   */
  public S hasDeletionTimestamp(String deletionTimestamp) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deletionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDeletionTimestamp = actual.getDeletionTimestamp();
    if (!Objects.areEqual(actualDeletionTimestamp, deletionTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, deletionTimestamp, actualDeletionTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's desiredState is equal to the given one.
   * @param desiredState the given desiredState to compare the actual Pod's desiredState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's desiredState is not equal to the given one.
   */
  public S hasDesiredState(PodState desiredState) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected desiredState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodState actualDesiredState = actual.getDesiredState();
    if (!Objects.areEqual(actualDesiredState, desiredState)) {
      failWithMessage(assertjErrorMessage, actual, desiredState, actualDesiredState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's generateName is equal to the given one.
   * @param generateName the given generateName to compare the actual Pod's generateName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's generateName is not equal to the given one.
   */
  public S hasGenerateName(String generateName) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected generateName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerateName = actual.getGenerateName();
    if (!Objects.areEqual(actualGenerateName, generateName)) {
      failWithMessage(assertjErrorMessage, actual, generateName, actualGenerateName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's id is equal to the given one.
   * @param id the given id to compare the actual Pod's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's kind is equal to the given one.
   * @param kind the given kind to compare the actual Pod's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's labels is equal to the given one.
   * @param labels the given labels to compare the actual Pod's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual Pod's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's nodeSelector is equal to the given one.
   * @param nodeSelector the given nodeSelector to compare the actual Pod's nodeSelector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's nodeSelector is not equal to the given one.
   */
  public S hasNodeSelector(java.util.Map nodeSelector) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualNodeSelector = actual.getNodeSelector();
    if (!Objects.areEqual(actualNodeSelector, nodeSelector)) {
      failWithMessage(assertjErrorMessage, actual, nodeSelector, actualNodeSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual Pod's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual Pod's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Pod's uid is equal to the given one.
   * @param uid the given uid to compare the actual Pod's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Pod's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual Pod we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
