package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeStatusFluentAssert<S extends AbstractNodeStatusFluentAssert<S, A>, A extends NodeStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeStatusFluentAssert}</code> to make assertions on actual NodeStatusFluent.
   * @param actual the NodeStatusFluent we want to make assertions on.
   */
  protected AbstractNodeStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluent's addresses contains the given NodeAddress elements.
   * @param addresses the given elements that should be contained in actual NodeStatusFluent's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluent's addresses does not contain all given NodeAddress elements.
   */
  public S hasAddresses(NodeAddress... addresses) {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) throw new AssertionError("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluent has no addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluent's addresses is not empty.
   */
  public S hasNoAddresses() {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have addresses but had :\n  <%s>";
    
    // check
    if (actual.getAddresses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAddresses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatusFluent's conditions contains the given NodeCondition elements.
   * @param conditions the given elements that should be contained in actual NodeStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluent's conditions does not contain all given NodeCondition elements.
   */
  public S hasConditions(NodeCondition... conditions) {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) throw new AssertionError("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluent has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluent's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatusFluent's nodeInfo is equal to the given one.
   * @param nodeInfo the given nodeInfo to compare the actual NodeStatusFluent's nodeInfo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluent's nodeInfo is not equal to the given one.
   */
  public S hasNodeInfo(NodeSystemInfo nodeInfo) {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected nodeInfo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeSystemInfo actualNodeInfo = actual.getNodeInfo();
    if (!Objects.areEqual(actualNodeInfo, nodeInfo)) {
      failWithMessage(assertjErrorMessage, actual, nodeInfo, actualNodeInfo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluent's phase is equal to the given one.
   * @param phase the given phase to compare the actual NodeStatusFluent's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluent's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual NodeStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
