package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeConditionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeConditionFluentAssert<S extends AbstractNodeConditionFluentAssert<S, A>, A extends NodeConditionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeConditionFluentAssert}</code> to make assertions on actual NodeConditionFluent.
   * @param actual the NodeConditionFluent we want to make assertions on.
   */
  protected AbstractNodeConditionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeConditionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeConditionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeConditionFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual NodeConditionFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeConditionFluent's lastProbeTime is equal to the given one.
   * @param lastProbeTime the given lastProbeTime to compare the actual NodeConditionFluent's lastProbeTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's lastProbeTime is not equal to the given one.
   */
  public S hasLastProbeTime(String lastProbeTime) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lastProbeTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastProbeTime = actual.getLastProbeTime();
    if (!Objects.areEqual(actualLastProbeTime, lastProbeTime)) {
      failWithMessage(assertjErrorMessage, actual, lastProbeTime, actualLastProbeTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeConditionFluent's lastTransitionTime is equal to the given one.
   * @param lastTransitionTime the given lastTransitionTime to compare the actual NodeConditionFluent's lastTransitionTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's lastTransitionTime is not equal to the given one.
   */
  public S hasLastTransitionTime(String lastTransitionTime) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lastTransitionTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastTransitionTime = actual.getLastTransitionTime();
    if (!Objects.areEqual(actualLastTransitionTime, lastTransitionTime)) {
      failWithMessage(assertjErrorMessage, actual, lastTransitionTime, actualLastTransitionTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeConditionFluent's message is equal to the given one.
   * @param message the given message to compare the actual NodeConditionFluent's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeConditionFluent's reason is equal to the given one.
   * @param reason the given reason to compare the actual NodeConditionFluent's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeConditionFluent's status is equal to the given one.
   * @param status the given status to compare the actual NodeConditionFluent's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeConditionFluent's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual NodeConditionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
