package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link MinionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractMinionFluentAssert<S extends AbstractMinionFluentAssert<S, A>, A extends MinionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractMinionFluentAssert}</code> to make assertions on actual MinionFluent.
   * @param actual the MinionFluent we want to make assertions on.
   */
  protected AbstractMinionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual MinionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual MinionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual MinionFluent's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual MinionFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Minion.ApiVersion apiVersion) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Minion.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual MinionFluent's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's deletionTimestamp is equal to the given one.
   * @param deletionTimestamp the given deletionTimestamp to compare the actual MinionFluent's deletionTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's deletionTimestamp is not equal to the given one.
   */
  public S hasDeletionTimestamp(String deletionTimestamp) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deletionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDeletionTimestamp = actual.getDeletionTimestamp();
    if (!Objects.areEqual(actualDeletionTimestamp, deletionTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, deletionTimestamp, actualDeletionTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's externalID is equal to the given one.
   * @param externalID the given externalID to compare the actual MinionFluent's externalID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's externalID is not equal to the given one.
   */
  public S hasExternalID(String externalID) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected externalID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualExternalID = actual.getExternalID();
    if (!Objects.areEqual(actualExternalID, externalID)) {
      failWithMessage(assertjErrorMessage, actual, externalID, actualExternalID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's generateName is equal to the given one.
   * @param generateName the given generateName to compare the actual MinionFluent's generateName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's generateName is not equal to the given one.
   */
  public S hasGenerateName(String generateName) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected generateName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerateName = actual.getGenerateName();
    if (!Objects.areEqual(actualGenerateName, generateName)) {
      failWithMessage(assertjErrorMessage, actual, generateName, actualGenerateName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's hostIP is equal to the given one.
   * @param hostIP the given hostIP to compare the actual MinionFluent's hostIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's hostIP is not equal to the given one.
   */
  public S hasHostIP(String hostIP) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHostIP = actual.getHostIP();
    if (!Objects.areEqual(actualHostIP, hostIP)) {
      failWithMessage(assertjErrorMessage, actual, hostIP, actualHostIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's id is equal to the given one.
   * @param id the given id to compare the actual MinionFluent's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual MinionFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's labels is equal to the given one.
   * @param labels the given labels to compare the actual MinionFluent's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual MinionFluent's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's podCIDR is equal to the given one.
   * @param podCIDR the given podCIDR to compare the actual MinionFluent's podCIDR to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's podCIDR is not equal to the given one.
   */
  public S hasPodCIDR(String podCIDR) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected podCIDR of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPodCIDR = actual.getPodCIDR();
    if (!Objects.areEqual(actualPodCIDR, podCIDR)) {
      failWithMessage(assertjErrorMessage, actual, podCIDR, actualPodCIDR);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual MinionFluent's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's resources is equal to the given one.
   * @param resources the given resources to compare the actual MinionFluent's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's resources is not equal to the given one.
   */
  public S hasResources(NodeResources resources) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeResources actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual MinionFluent's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's status is equal to the given one.
   * @param status the given status to compare the actual MinionFluent's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's status is not equal to the given one.
   */
  public S hasStatus(NodeStatus status) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeStatus actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual MinionFluent's uid is equal to the given one.
   * @param uid the given uid to compare the actual MinionFluent's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual MinionFluent's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual MinionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
