package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LivenessProbe} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLivenessProbeAssert<S extends AbstractLivenessProbeAssert<S, A>, A extends LivenessProbe> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLivenessProbeAssert}</code> to make assertions on actual LivenessProbe.
   * @param actual the LivenessProbe we want to make assertions on.
   */
  protected AbstractLivenessProbeAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LivenessProbe's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LivenessProbe's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LivenessProbe's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LivenessProbe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LivenessProbe's exec is equal to the given one.
   * @param exec the given exec to compare the actual LivenessProbe's exec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LivenessProbe's exec is not equal to the given one.
   */
  public S hasExec(ExecAction exec) {
    // check that actual LivenessProbe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected exec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ExecAction actualExec = actual.getExec();
    if (!Objects.areEqual(actualExec, exec)) {
      failWithMessage(assertjErrorMessage, actual, exec, actualExec);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LivenessProbe's httpGet is equal to the given one.
   * @param httpGet the given httpGet to compare the actual LivenessProbe's httpGet to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LivenessProbe's httpGet is not equal to the given one.
   */
  public S hasHttpGet(HTTPGetAction httpGet) {
    // check that actual LivenessProbe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected httpGet of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HTTPGetAction actualHttpGet = actual.getHttpGet();
    if (!Objects.areEqual(actualHttpGet, httpGet)) {
      failWithMessage(assertjErrorMessage, actual, httpGet, actualHttpGet);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LivenessProbe's initialDelaySeconds is equal to the given one.
   * @param initialDelaySeconds the given initialDelaySeconds to compare the actual LivenessProbe's initialDelaySeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LivenessProbe's initialDelaySeconds is not equal to the given one.
   */
  public S hasInitialDelaySeconds(Integer initialDelaySeconds) {
    // check that actual LivenessProbe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected initialDelaySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualInitialDelaySeconds = actual.getInitialDelaySeconds();
    if (!Objects.areEqual(actualInitialDelaySeconds, initialDelaySeconds)) {
      failWithMessage(assertjErrorMessage, actual, initialDelaySeconds, actualInitialDelaySeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LivenessProbe's tcpSocket is equal to the given one.
   * @param tcpSocket the given tcpSocket to compare the actual LivenessProbe's tcpSocket to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LivenessProbe's tcpSocket is not equal to the given one.
   */
  public S hasTcpSocket(TCPSocketAction tcpSocket) {
    // check that actual LivenessProbe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected tcpSocket of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    TCPSocketAction actualTcpSocket = actual.getTcpSocket();
    if (!Objects.areEqual(actualTcpSocket, tcpSocket)) {
      failWithMessage(assertjErrorMessage, actual, tcpSocket, actualTcpSocket);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LivenessProbe's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual LivenessProbe's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LivenessProbe's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Integer timeoutSeconds) {
    // check that actual LivenessProbe we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
