package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Endpoints} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointsAssert<S extends AbstractEndpointsAssert<S, A>, A extends Endpoints> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointsAssert}</code> to make assertions on actual Endpoints.
   * @param actual the Endpoints we want to make assertions on.
   */
  protected AbstractEndpointsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Endpoints's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Endpoints's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual Endpoints's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Endpoints's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(Endpoints.ApiVersion apiVersion) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Endpoints.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual Endpoints's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's deletionTimestamp is equal to the given one.
   * @param deletionTimestamp the given deletionTimestamp to compare the actual Endpoints's deletionTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's deletionTimestamp is not equal to the given one.
   */
  public S hasDeletionTimestamp(String deletionTimestamp) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected deletionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDeletionTimestamp = actual.getDeletionTimestamp();
    if (!Objects.areEqual(actualDeletionTimestamp, deletionTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, deletionTimestamp, actualDeletionTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's endpoints contains the given String elements.
   * @param endpoints the given elements that should be contained in actual Endpoints's endpoints.
   * @return this assertion object.
   * @throws AssertionError if the actual Endpoints's endpoints does not contain all given String elements.
   */
  public S hasEndpoints(String... endpoints) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (endpoints == null) throw new AssertionError("Expecting endpoints parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEndpoints(), endpoints);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints has no endpoints.
   * @return this assertion object.
   * @throws AssertionError if the actual Endpoints's endpoints is not empty.
   */
  public S hasNoEndpoints() {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have endpoints but had :\n  <%s>";
    
    // check
    if (actual.getEndpoints().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEndpoints());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Endpoints's generateName is equal to the given one.
   * @param generateName the given generateName to compare the actual Endpoints's generateName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's generateName is not equal to the given one.
   */
  public S hasGenerateName(String generateName) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected generateName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualGenerateName = actual.getGenerateName();
    if (!Objects.areEqual(actualGenerateName, generateName)) {
      failWithMessage(assertjErrorMessage, actual, generateName, actualGenerateName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's id is equal to the given one.
   * @param id the given id to compare the actual Endpoints's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's kind is equal to the given one.
   * @param kind the given kind to compare the actual Endpoints's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual Endpoints's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's protocol is equal to the given one.
   * @param protocol the given protocol to compare the actual Endpoints's protocol to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's protocol is not equal to the given one.
   */
  public S hasProtocol(String protocol) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected protocol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProtocol = actual.getProtocol();
    if (!Objects.areEqual(actualProtocol, protocol)) {
      failWithMessage(assertjErrorMessage, actual, protocol, actualProtocol);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual Endpoints's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual Endpoints's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints's subsets contains the given EndpointSubset elements.
   * @param subsets the given elements that should be contained in actual Endpoints's subsets.
   * @return this assertion object.
   * @throws AssertionError if the actual Endpoints's subsets does not contain all given EndpointSubset elements.
   */
  public S hasSubsets(EndpointSubset... subsets) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointSubset varargs is not null.
    if (subsets == null) throw new AssertionError("Expecting subsets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSubsets(), subsets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints has no subsets.
   * @return this assertion object.
   * @throws AssertionError if the actual Endpoints's subsets is not empty.
   */
  public S hasNoSubsets() {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have subsets but had :\n  <%s>";
    
    // check
    if (actual.getSubsets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSubsets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Endpoints's targetRefs contains the given EndpointObjectReference elements.
   * @param targetRefs the given elements that should be contained in actual Endpoints's targetRefs.
   * @return this assertion object.
   * @throws AssertionError if the actual Endpoints's targetRefs does not contain all given EndpointObjectReference elements.
   */
  public S hasTargetRefs(EndpointObjectReference... targetRefs) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // check that given EndpointObjectReference varargs is not null.
    if (targetRefs == null) throw new AssertionError("Expecting targetRefs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTargetRefs(), targetRefs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Endpoints has no targetRefs.
   * @return this assertion object.
   * @throws AssertionError if the actual Endpoints's targetRefs is not empty.
   */
  public S hasNoTargetRefs() {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have targetRefs but had :\n  <%s>";
    
    // check
    if (actual.getTargetRefs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTargetRefs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Endpoints's uid is equal to the given one.
   * @param uid the given uid to compare the actual Endpoints's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Endpoints's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
