package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EndpointObjectReference} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointObjectReferenceAssert<S extends AbstractEndpointObjectReferenceAssert<S, A>, A extends EndpointObjectReference> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointObjectReferenceAssert}</code> to make assertions on actual EndpointObjectReference.
   * @param actual the EndpointObjectReference we want to make assertions on.
   */
  protected AbstractEndpointObjectReferenceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EndpointObjectReference's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EndpointObjectReference's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual EndpointObjectReference's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(EndpointObjectReference.ApiVersion apiVersion) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EndpointObjectReference.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's endpoint is equal to the given one.
   * @param endpoint the given endpoint to compare the actual EndpointObjectReference's endpoint to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's endpoint is not equal to the given one.
   */
  public S hasEndpoint(String endpoint) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected endpoint of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualEndpoint = actual.getEndpoint();
    if (!Objects.areEqual(actualEndpoint, endpoint)) {
      failWithMessage(assertjErrorMessage, actual, endpoint, actualEndpoint);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's fieldPath is equal to the given one.
   * @param fieldPath the given fieldPath to compare the actual EndpointObjectReference's fieldPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's fieldPath is not equal to the given one.
   */
  public S hasFieldPath(String fieldPath) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected fieldPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFieldPath = actual.getFieldPath();
    if (!Objects.areEqual(actualFieldPath, fieldPath)) {
      failWithMessage(assertjErrorMessage, actual, fieldPath, actualFieldPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's kind is equal to the given one.
   * @param kind the given kind to compare the actual EndpointObjectReference's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's name is equal to the given one.
   * @param name the given name to compare the actual EndpointObjectReference's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual EndpointObjectReference's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual EndpointObjectReference's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(String resourceVersion) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EndpointObjectReference's uid is equal to the given one.
   * @param uid the given uid to compare the actual EndpointObjectReference's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EndpointObjectReference's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual EndpointObjectReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
