package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Container} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerAssert<S extends AbstractContainerAssert<S, A>, A extends Container> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerAssert}</code> to make assertions on actual Container.
   * @param actual the Container we want to make assertions on.
   */
  protected AbstractContainerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Container's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Container's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's capabilities is equal to the given one.
   * @param capabilities the given capabilities to compare the actual Container's capabilities to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's capabilities is not equal to the given one.
   */
  public S hasCapabilities(Capabilities capabilities) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected capabilities of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Capabilities actualCapabilities = actual.getCapabilities();
    if (!Objects.areEqual(actualCapabilities, capabilities)) {
      failWithMessage(assertjErrorMessage, actual, capabilities, actualCapabilities);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's command contains the given String elements.
   * @param command the given elements that should be contained in actual Container's command.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) throw new AssertionError("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Container's cpu is equal to the given one.
   * @param cpu the given cpu to compare the actual Container's cpu to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's cpu is not equal to the given one.
   */
  public S hasCpu(Integer cpu) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected cpu of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCpu = actual.getCpu();
    if (!Objects.areEqual(actualCpu, cpu)) {
      failWithMessage(assertjErrorMessage, actual, cpu, actualCpu);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's entrypointOmitempty contains the given String elements.
   * @param entrypointOmitempty the given elements that should be contained in actual Container's entrypointOmitempty.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's entrypointOmitempty does not contain all given String elements.
   */
  public S hasEntrypointOmitempty(String... entrypointOmitempty) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (entrypointOmitempty == null) throw new AssertionError("Expecting entrypointOmitempty parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEntrypointOmitempty(), entrypointOmitempty);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container has no entrypointOmitempty.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's entrypointOmitempty is not empty.
   */
  public S hasNoEntrypointOmitempty() {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have entrypointOmitempty but had :\n  <%s>";
    
    // check
    if (actual.getEntrypointOmitempty().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEntrypointOmitempty());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Container's env contains the given EnvVar elements.
   * @param env the given elements that should be contained in actual Container's env.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's env does not contain all given EnvVar elements.
   */
  public S hasEnv(EnvVar... env) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // check that given EnvVar varargs is not null.
    if (env == null) throw new AssertionError("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Container's image is equal to the given one.
   * @param image the given image to compare the actual Container's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's imagePullPolicy is equal to the given one.
   * @param imagePullPolicy the given imagePullPolicy to compare the actual Container's imagePullPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's imagePullPolicy is not equal to the given one.
   */
  public S hasImagePullPolicy(String imagePullPolicy) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected imagePullPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImagePullPolicy = actual.getImagePullPolicy();
    if (!Objects.areEqual(actualImagePullPolicy, imagePullPolicy)) {
      failWithMessage(assertjErrorMessage, actual, imagePullPolicy, actualImagePullPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's lifecycle is equal to the given one.
   * @param lifecycle the given lifecycle to compare the actual Container's lifecycle to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's lifecycle is not equal to the given one.
   */
  public S hasLifecycle(Lifecycle lifecycle) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected lifecycle of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Lifecycle actualLifecycle = actual.getLifecycle();
    if (!Objects.areEqual(actualLifecycle, lifecycle)) {
      failWithMessage(assertjErrorMessage, actual, lifecycle, actualLifecycle);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's livenessProbe is equal to the given one.
   * @param livenessProbe the given livenessProbe to compare the actual Container's livenessProbe to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's livenessProbe is not equal to the given one.
   */
  public S hasLivenessProbe(LivenessProbe livenessProbe) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected livenessProbe of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LivenessProbe actualLivenessProbe = actual.getLivenessProbe();
    if (!Objects.areEqual(actualLivenessProbe, livenessProbe)) {
      failWithMessage(assertjErrorMessage, actual, livenessProbe, actualLivenessProbe);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's memory is equal to the given one.
   * @param memory the given memory to compare the actual Container's memory to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's memory is not equal to the given one.
   */
  public S hasMemory(Integer memory) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected memory of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMemory = actual.getMemory();
    if (!Objects.areEqual(actualMemory, memory)) {
      failWithMessage(assertjErrorMessage, actual, memory, actualMemory);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's name is equal to the given one.
   * @param name the given name to compare the actual Container's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's ports contains the given ContainerPort elements.
   * @param ports the given elements that should be contained in actual Container's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's ports does not contain all given ContainerPort elements.
   */
  public S hasPorts(ContainerPort... ports) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerPort varargs is not null.
    if (ports == null) throw new AssertionError("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container has no ports.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's ports is not empty.
   */
  public S hasNoPorts() {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have ports but had :\n  <%s>";
    
    // check
    if (actual.getPorts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPorts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Container's privileged is equal to the given one.
   * @param privileged the given privileged to compare the actual Container's privileged to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's privileged is not equal to the given one.
   */
  public S hasPrivileged(Boolean privileged) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected privileged of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualPrivileged = actual.getPrivileged();
    if (!Objects.areEqual(actualPrivileged, privileged)) {
      failWithMessage(assertjErrorMessage, actual, privileged, actualPrivileged);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's readinessProbe is equal to the given one.
   * @param readinessProbe the given readinessProbe to compare the actual Container's readinessProbe to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's readinessProbe is not equal to the given one.
   */
  public S hasReadinessProbe(LivenessProbe readinessProbe) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected readinessProbe of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LivenessProbe actualReadinessProbe = actual.getReadinessProbe();
    if (!Objects.areEqual(actualReadinessProbe, readinessProbe)) {
      failWithMessage(assertjErrorMessage, actual, readinessProbe, actualReadinessProbe);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's resources is equal to the given one.
   * @param resources the given resources to compare the actual Container's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's resources is not equal to the given one.
   */
  public S hasResources(ResourceRequirements resources) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's terminationMessagePath is equal to the given one.
   * @param terminationMessagePath the given terminationMessagePath to compare the actual Container's terminationMessagePath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's terminationMessagePath is not equal to the given one.
   */
  public S hasTerminationMessagePath(String terminationMessagePath) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected terminationMessagePath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTerminationMessagePath = actual.getTerminationMessagePath();
    if (!Objects.areEqual(actualTerminationMessagePath, terminationMessagePath)) {
      failWithMessage(assertjErrorMessage, actual, terminationMessagePath, actualTerminationMessagePath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container's volumeMounts contains the given VolumeMount elements.
   * @param volumeMounts the given elements that should be contained in actual Container's volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's volumeMounts does not contain all given VolumeMount elements.
   */
  public S hasVolumeMounts(VolumeMount... volumeMounts) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // check that given VolumeMount varargs is not null.
    if (volumeMounts == null) throw new AssertionError("Expecting volumeMounts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVolumeMounts(), volumeMounts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Container has no volumeMounts.
   * @return this assertion object.
   * @throws AssertionError if the actual Container's volumeMounts is not empty.
   */
  public S hasNoVolumeMounts() {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumeMounts but had :\n  <%s>";
    
    // check
    if (actual.getVolumeMounts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVolumeMounts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual Container's workingDir is equal to the given one.
   * @param workingDir the given workingDir to compare the actual Container's workingDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Container's workingDir is not equal to the given one.
   */
  public S hasWorkingDir(String workingDir) {
    // check that actual Container we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected workingDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualWorkingDir = actual.getWorkingDir();
    if (!Objects.areEqual(actualWorkingDir, workingDir)) {
      failWithMessage(assertjErrorMessage, actual, workingDir, actualWorkingDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
