package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerManifestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerManifestAssert assertThat(io.fabric8.kubernetes.api.model.ContainerManifest actual) {
    return new io.fabric8.kubernetes.api.model.ContainerManifestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerManifestBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerManifestBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerManifestBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerManifestBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerManifestFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerManifestFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerManifestFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerManifestFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDir actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirFluentAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirFluent actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDisk actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskFluentAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskFluent actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoAssert assertThat(io.fabric8.kubernetes.api.model.GitRepo actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoFluentAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoFluent actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HandlerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HandlerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerFluentAssert assertThat(io.fabric8.kubernetes.api.model.HandlerFluent actual) {
    return new io.fabric8.kubernetes.api.model.HandlerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostDirAssert assertThat(io.fabric8.kubernetes.api.model.HostDir actual) {
    return new io.fabric8.kubernetes.api.model.HostDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostDirBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostDirBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HostDirBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HostDirBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostDirFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostDirFluentAssert assertThat(io.fabric8.kubernetes.api.model.HostDirFluent actual) {
    return new io.fabric8.kubernetes.api.model.HostDirFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleFluentAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleFluent actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LivenessProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LivenessProbeAssert assertThat(io.fabric8.kubernetes.api.model.LivenessProbe actual) {
    return new io.fabric8.kubernetes.api.model.LivenessProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LivenessProbeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LivenessProbeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LivenessProbeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LivenessProbeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LivenessProbeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LivenessProbeFluentAssert assertThat(io.fabric8.kubernetes.api.model.LivenessProbeFluent actual) {
    return new io.fabric8.kubernetes.api.model.LivenessProbeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionAssert assertThat(io.fabric8.kubernetes.api.model.Minion actual) {
    return new io.fabric8.kubernetes.api.model.MinionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.MinionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.MinionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionFluentAssert assertThat(io.fabric8.kubernetes.api.model.MinionFluent actual) {
    return new io.fabric8.kubernetes.api.model.MinionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionListAssert assertThat(io.fabric8.kubernetes.api.model.MinionList actual) {
    return new io.fabric8.kubernetes.api.model.MinionListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.MinionListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.MinionListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionListFluentAssert assertThat(io.fabric8.kubernetes.api.model.MinionListFluent actual) {
    return new io.fabric8.kubernetes.api.model.MinionListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeResourcesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeResourcesAssert assertThat(io.fabric8.kubernetes.api.model.NodeResources actual) {
    return new io.fabric8.kubernetes.api.model.NodeResourcesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeResourcesBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeResourcesBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeResourcesBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeResourcesBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeResourcesFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeResourcesFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeResourcesFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeResourcesFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStateAssert assertThat(io.fabric8.kubernetes.api.model.PodState actual) {
    return new io.fabric8.kubernetes.api.model.PodStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodStateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodStateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStateFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodStateFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodStateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplate actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortAssert assertThat(io.fabric8.kubernetes.api.model.Port actual) {
    return new io.fabric8.kubernetes.api.model.PortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortFluentAssert assertThat(io.fabric8.kubernetes.api.model.PortFluent actual) {
    return new io.fabric8.kubernetes.api.model.PortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerState actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStateFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStateFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicy actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyAlways actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAlwaysBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAlwaysBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyAlwaysBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAlwaysBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAlwaysFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAlwaysFluentAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyAlwaysFluent actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAlwaysFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyFluentAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyFluent actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyNever actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyNeverBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyNeverBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyNeverBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyNeverBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyNeverFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyNeverFluentAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyNeverFluent actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyNeverFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyOnFailure actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyOnFailureBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyOnFailureBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyOnFailureBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyOnFailureBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyOnFailureFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyOnFailureFluentAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyOnFailureFluent actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyOnFailureFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.VolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.VolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.base.Container actual) {
    return new io.fabric8.kubernetes.api.model.base.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.EmptyDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.EmptyDirAssert assertThat(io.fabric8.kubernetes.api.model.base.EmptyDir actual) {
    return new io.fabric8.kubernetes.api.model.base.EmptyDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.base.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.base.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.base.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.base.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.GCEPersistentDiskAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.GCEPersistentDiskAssert assertThat(io.fabric8.kubernetes.api.model.base.GCEPersistentDisk actual) {
    return new io.fabric8.kubernetes.api.model.base.GCEPersistentDiskAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.GitRepoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.GitRepoAssert assertThat(io.fabric8.kubernetes.api.model.base.GitRepo actual) {
    return new io.fabric8.kubernetes.api.model.base.GitRepoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.base.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.base.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.base.Handler actual) {
    return new io.fabric8.kubernetes.api.model.base.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.HostDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.HostDirAssert assertThat(io.fabric8.kubernetes.api.model.base.HostDir actual) {
    return new io.fabric8.kubernetes.api.model.base.HostDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.base.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.base.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.LivenessProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.LivenessProbeAssert assertThat(io.fabric8.kubernetes.api.model.base.LivenessProbe actual) {
    return new io.fabric8.kubernetes.api.model.base.LivenessProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.base.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.base.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.base.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.base.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.base.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.base.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.PortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.PortAssert assertThat(io.fabric8.kubernetes.api.model.base.Port actual) {
    return new io.fabric8.kubernetes.api.model.base.PortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.base.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.base.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicy actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyAlwaysAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyAlwaysAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicyAlways actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyAlwaysAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyNeverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyNeverAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicyNever actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyNeverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailureAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailure actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusAssert assertThat(io.fabric8.kubernetes.api.model.base.Status actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.base.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.base.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.base.Volume actual) {
    return new io.fabric8.kubernetes.api.model.base.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.base.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.base.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.VolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.VolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.base.VolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.base.VolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.errors.StatusErrorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.errors.StatusErrorAssert assertThat(io.fabric8.kubernetes.api.model.errors.StatusError actual) {
    return new io.fabric8.kubernetes.api.model.errors.StatusErrorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.errors.StatusErrorBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.errors.StatusErrorBuilderAssert assertThat(io.fabric8.kubernetes.api.model.errors.StatusErrorBuilder actual) {
    return new io.fabric8.kubernetes.api.model.errors.StatusErrorBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.errors.StatusErrorFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.errors.StatusErrorFluentAssert assertThat(io.fabric8.kubernetes.api.model.errors.StatusErrorFluent actual) {
    return new io.fabric8.kubernetes.api.model.errors.StatusErrorFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.resource.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityBuilderAssert assertThat(io.fabric8.kubernetes.api.model.resource.QuantityBuilder actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityFluentAssert assertThat(io.fabric8.kubernetes.api.model.resource.QuantityFluent actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert assertThat(io.fabric8.kubernetes.api.model.runtime.RawExtension actual) {
    return new io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentAssert assertThat(io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent actual) {
    return new io.fabric8.kubernetes.api.model.runtime.RawExtensionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringBuilderAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrStringBuilder actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringFluentAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrStringFluent actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringFluentAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
