package io.fabric8.kubernetes.api.model.base;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeSourceAssert<S extends AbstractVolumeSourceAssert<S, A>, A extends VolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeSourceAssert}</code> to make assertions on actual VolumeSource.
   * @param actual the VolumeSource we want to make assertions on.
   */
  protected AbstractVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual VolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual VolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSource's emptyDir is equal to the given one.
   * @param emptyDir the given emptyDir to compare the actual VolumeSource's emptyDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSource's emptyDir is not equal to the given one.
   */
  public S hasEmptyDir(EmptyDir emptyDir) {
    // check that actual VolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected emptyDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EmptyDir actualEmptyDir = actual.getEmptyDir();
    if (!Objects.areEqual(actualEmptyDir, emptyDir)) {
      failWithMessage(assertjErrorMessage, actual, emptyDir, actualEmptyDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSource's gitRepo is equal to the given one.
   * @param gitRepo the given gitRepo to compare the actual VolumeSource's gitRepo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSource's gitRepo is not equal to the given one.
   */
  public S hasGitRepo(GitRepo gitRepo) {
    // check that actual VolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected gitRepo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitRepo actualGitRepo = actual.getGitRepo();
    if (!Objects.areEqual(actualGitRepo, gitRepo)) {
      failWithMessage(assertjErrorMessage, actual, gitRepo, actualGitRepo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSource's hostDir is equal to the given one.
   * @param hostDir the given hostDir to compare the actual VolumeSource's hostDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSource's hostDir is not equal to the given one.
   */
  public S hasHostDir(HostDir hostDir) {
    // check that actual VolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected hostDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HostDir actualHostDir = actual.getHostDir();
    if (!Objects.areEqual(actualHostDir, hostDir)) {
      failWithMessage(assertjErrorMessage, actual, hostDir, actualHostDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeSource's persistentDisk is equal to the given one.
   * @param persistentDisk the given persistentDisk to compare the actual VolumeSource's persistentDisk to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeSource's persistentDisk is not equal to the given one.
   */
  public S hasPersistentDisk(GCEPersistentDisk persistentDisk) {
    // check that actual VolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected persistentDisk of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GCEPersistentDisk actualPersistentDisk = actual.getPersistentDisk();
    if (!Objects.areEqual(actualPersistentDisk, persistentDisk)) {
      failWithMessage(assertjErrorMessage, actual, persistentDisk, actualPersistentDisk);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
