package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubernetesListFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesListFluentAssert<S extends AbstractKubernetesListFluentAssert<S, A>, A extends KubernetesListFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesListFluentAssert}</code> to make assertions on actual KubernetesListFluent.
   * @param actual the KubernetesListFluent we want to make assertions on.
   */
  protected AbstractKubernetesListFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubernetesListFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KubernetesListFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual KubernetesListFluent's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual KubernetesListFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's buildConfigs contains the given io.fabric8.openshift.api.model.BuildConfig elements.
   * @param buildConfigs the given elements that should be contained in actual KubernetesListFluent's buildConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's buildConfigs does not contain all given io.fabric8.openshift.api.model.BuildConfig elements.
   */
  public S hasBuildConfigs(io.fabric8.openshift.api.model.BuildConfig... buildConfigs) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.BuildConfig varargs is not null.
    if (buildConfigs == null) throw new AssertionError("Expecting buildConfigs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getBuildConfigs(), buildConfigs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no buildConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's buildConfigs is not empty.
   */
  public S hasNoBuildConfigs() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have buildConfigs but had :\n  <%s>";
    
    // check
    if (actual.getBuildConfigs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getBuildConfigs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's creationTimestamp is equal to the given one.
   * @param creationTimestamp the given creationTimestamp to compare the actual KubernetesListFluent's creationTimestamp to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's creationTimestamp is not equal to the given one.
   */
  public S hasCreationTimestamp(String creationTimestamp) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreationTimestamp = actual.getCreationTimestamp();
    if (!Objects.areEqual(actualCreationTimestamp, creationTimestamp)) {
      failWithMessage(assertjErrorMessage, actual, creationTimestamp, actualCreationTimestamp);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's deploymentConfigs contains the given io.fabric8.openshift.api.model.DeploymentConfig elements.
   * @param deploymentConfigs the given elements that should be contained in actual KubernetesListFluent's deploymentConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's deploymentConfigs does not contain all given io.fabric8.openshift.api.model.DeploymentConfig elements.
   */
  public S hasDeploymentConfigs(io.fabric8.openshift.api.model.DeploymentConfig... deploymentConfigs) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.DeploymentConfig varargs is not null.
    if (deploymentConfigs == null) throw new AssertionError("Expecting deploymentConfigs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDeploymentConfigs(), deploymentConfigs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no deploymentConfigs.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's deploymentConfigs is not empty.
   */
  public S hasNoDeploymentConfigs() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have deploymentConfigs but had :\n  <%s>";
    
    // check
    if (actual.getDeploymentConfigs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getDeploymentConfigs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's id is equal to the given one.
   * @param id the given id to compare the actual KubernetesListFluent's id to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's id is not equal to the given one.
   */
  public S hasId(String id) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualId = actual.getId();
    if (!Objects.areEqual(actualId, id)) {
      failWithMessage(assertjErrorMessage, actual, id, actualId);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's imageRepositories contains the given io.fabric8.openshift.api.model.ImageRepository elements.
   * @param imageRepositories the given elements that should be contained in actual KubernetesListFluent's imageRepositories.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's imageRepositories does not contain all given io.fabric8.openshift.api.model.ImageRepository elements.
   */
  public S hasImageRepositories(io.fabric8.openshift.api.model.ImageRepository... imageRepositories) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.ImageRepository varargs is not null.
    if (imageRepositories == null) throw new AssertionError("Expecting imageRepositories parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImageRepositories(), imageRepositories);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no imageRepositories.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's imageRepositories is not empty.
   */
  public S hasNoImageRepositories() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have imageRepositories but had :\n  <%s>";
    
    // check
    if (actual.getImageRepositories().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImageRepositories());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's items contains the given Object elements.
   * @param items the given elements that should be contained in actual KubernetesListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's items does not contain all given Object elements.
   */
  public S hasItems(Object... items) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Object varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's items is not empty.
   */
  public S hasNoItems() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual KubernetesListFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual KubernetesListFluent's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's pods contains the given Pod elements.
   * @param pods the given elements that should be contained in actual KubernetesListFluent's pods.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's pods does not contain all given Pod elements.
   */
  public S hasPods(Pod... pods) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Pod varargs is not null.
    if (pods == null) throw new AssertionError("Expecting pods parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPods(), pods);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no pods.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's pods is not empty.
   */
  public S hasNoPods() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have pods but had :\n  <%s>";
    
    // check
    if (actual.getPods().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPods());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's replicationControllers contains the given ReplicationController elements.
   * @param replicationControllers the given elements that should be contained in actual KubernetesListFluent's replicationControllers.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's replicationControllers does not contain all given ReplicationController elements.
   */
  public S hasReplicationControllers(ReplicationController... replicationControllers) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicationController varargs is not null.
    if (replicationControllers == null) throw new AssertionError("Expecting replicationControllers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getReplicationControllers(), replicationControllers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no replicationControllers.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's replicationControllers is not empty.
   */
  public S hasNoReplicationControllers() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have replicationControllers but had :\n  <%s>";
    
    // check
    if (actual.getReplicationControllers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getReplicationControllers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual KubernetesListFluent's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(Integer resourceVersion) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's routes contains the given io.fabric8.openshift.api.model.Route elements.
   * @param routes the given elements that should be contained in actual KubernetesListFluent's routes.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's routes does not contain all given io.fabric8.openshift.api.model.Route elements.
   */
  public S hasRoutes(io.fabric8.openshift.api.model.Route... routes) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.openshift.api.model.Route varargs is not null.
    if (routes == null) throw new AssertionError("Expecting routes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRoutes(), routes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no routes.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's routes is not empty.
   */
  public S hasNoRoutes() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have routes but had :\n  <%s>";
    
    // check
    if (actual.getRoutes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRoutes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual KubernetesListFluent's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent's services contains the given Service elements.
   * @param services the given elements that should be contained in actual KubernetesListFluent's services.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's services does not contain all given Service elements.
   */
  public S hasServices(Service... services) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given Service varargs is not null.
    if (services == null) throw new AssertionError("Expecting services parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getServices(), services);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesListFluent has no services.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesListFluent's services is not empty.
   */
  public S hasNoServices() {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have services but had :\n  <%s>";
    
    // check
    if (actual.getServices().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getServices());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual KubernetesListFluent's uid is equal to the given one.
   * @param uid the given uid to compare the actual KubernetesListFluent's uid to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubernetesListFluent's uid is not equal to the given one.
   */
  public S hasUid(String uid) {
    // check that actual KubernetesListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUid = actual.getUid();
    if (!Objects.areEqual(actualUid, uid)) {
      failWithMessage(assertjErrorMessage, actual, uid, actualUid);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
