package io.fabric8.kubernetes.api.model.runtime;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RawExtension} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRawExtensionAssert<S extends AbstractRawExtensionAssert<S, A>, A extends RawExtension> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRawExtensionAssert}</code> to make assertions on actual RawExtension.
   * @param actual the RawExtension we want to make assertions on.
   */
  protected AbstractRawExtensionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RawExtension's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RawExtension's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RawExtension's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RawExtension we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RawExtension's rawJSON contains the given Integer elements.
   * @param rawJSON the given elements that should be contained in actual RawExtension's rawJSON.
   * @return this assertion object.
   * @throws AssertionError if the actual RawExtension's rawJSON does not contain all given Integer elements.
   */
  public S hasRawJSON(Integer... rawJSON) {
    // check that actual RawExtension we want to make assertions on is not null.
    isNotNull();

    // check that given Integer varargs is not null.
    if (rawJSON == null) throw new AssertionError("Expecting rawJSON parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRawJSON(), rawJSON);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RawExtension has no rawJSON.
   * @return this assertion object.
   * @throws AssertionError if the actual RawExtension's rawJSON is not empty.
   */
  public S hasNoRawJSON() {
    // check that actual RawExtension we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have rawJSON but had :\n  <%s>";
    
    // check
    if (actual.getRawJSON().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRawJSON());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
