package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplateFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateFluentAssert<S extends AbstractPodTemplateFluentAssert<S, A>, A extends PodTemplateFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateFluentAssert}</code> to make assertions on actual PodTemplateFluent.
   * @param actual the PodTemplateFluent we want to make assertions on.
   */
  protected AbstractPodTemplateFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplateFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplateFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplateFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateFluent's desiredState is equal to the given one.
   * @param desiredState the given desiredState to compare the actual PodTemplateFluent's desiredState to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateFluent's desiredState is not equal to the given one.
   */
  public S hasDesiredState(PodState desiredState) {
    // check that actual PodTemplateFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected desiredState of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodState actualDesiredState = actual.getDesiredState();
    if (!Objects.areEqual(actualDesiredState, desiredState)) {
      failWithMessage(assertjErrorMessage, actual, desiredState, actualDesiredState);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplateFluent's labels is equal to the given one.
   * @param labels the given labels to compare the actual PodTemplateFluent's labels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplateFluent's labels is not equal to the given one.
   */
  public S hasLabels(java.util.Map labels) {
    // check that actual PodTemplateFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLabels = actual.getLabels();
    if (!Objects.areEqual(actualLabels, labels)) {
      failWithMessage(assertjErrorMessage, actual, labels, actualLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
