package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link VolumeFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeFluentAssert<S extends AbstractVolumeFluentAssert<S, A>, A extends VolumeFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeFluentAssert}</code> to make assertions on actual VolumeFluent.
   * @param actual the VolumeFluent we want to make assertions on.
   */
  protected AbstractVolumeFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual VolumeFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual VolumeFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual VolumeFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluent's name is equal to the given one.
   * @param name the given name to compare the actual VolumeFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual VolumeFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual VolumeFluent's source is equal to the given one.
   * @param source the given source to compare the actual VolumeFluent's source to.
   * @return this assertion object.
   * @throws AssertionError - if the actual VolumeFluent's source is not equal to the given one.
   */
  public S hasSource(VolumeSource source) {
    // check that actual VolumeFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected source of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    VolumeSource actualSource = actual.getSource();
    if (!Objects.areEqual(actualSource, source)) {
      failWithMessage(assertjErrorMessage, actual, source, actualSource);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
