package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeResourcesFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeResourcesFluentAssert<S extends AbstractNodeResourcesFluentAssert<S, A>, A extends NodeResourcesFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeResourcesFluentAssert}</code> to make assertions on actual NodeResourcesFluent.
   * @param actual the NodeResourcesFluent we want to make assertions on.
   */
  protected AbstractNodeResourcesFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeResourcesFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeResourcesFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeResourcesFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeResourcesFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeResourcesFluent's capacity is equal to the given one.
   * @param capacity the given capacity to compare the actual NodeResourcesFluent's capacity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeResourcesFluent's capacity is not equal to the given one.
   */
  public S hasCapacity(java.util.Map capacity) {
    // check that actual NodeResourcesFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected capacity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualCapacity = actual.getCapacity();
    if (!Objects.areEqual(actualCapacity, capacity)) {
      failWithMessage(assertjErrorMessage, actual, capacity, actualCapacity);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
