package io.fabric8.kubernetes.api.model.base;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RestartPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRestartPolicyAssert<S extends AbstractRestartPolicyAssert<S, A>, A extends RestartPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRestartPolicyAssert}</code> to make assertions on actual RestartPolicy.
   * @param actual the RestartPolicy we want to make assertions on.
   */
  protected AbstractRestartPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RestartPolicy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RestartPolicy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RestartPolicy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RestartPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RestartPolicy's always is equal to the given one.
   * @param always the given always to compare the actual RestartPolicy's always to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RestartPolicy's always is not equal to the given one.
   */
  public S hasAlways(RestartPolicyAlways always) {
    // check that actual RestartPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected always of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RestartPolicyAlways actualAlways = actual.getAlways();
    if (!Objects.areEqual(actualAlways, always)) {
      failWithMessage(assertjErrorMessage, actual, always, actualAlways);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RestartPolicy's never is equal to the given one.
   * @param never the given never to compare the actual RestartPolicy's never to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RestartPolicy's never is not equal to the given one.
   */
  public S hasNever(RestartPolicyNever never) {
    // check that actual RestartPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected never of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RestartPolicyNever actualNever = actual.getNever();
    if (!Objects.areEqual(actualNever, never)) {
      failWithMessage(assertjErrorMessage, actual, never, actualNever);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RestartPolicy's onFailure is equal to the given one.
   * @param onFailure the given onFailure to compare the actual RestartPolicy's onFailure to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RestartPolicy's onFailure is not equal to the given one.
   */
  public S hasOnFailure(RestartPolicyOnFailure onFailure) {
    // check that actual RestartPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected onFailure of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RestartPolicyOnFailure actualOnFailure = actual.getOnFailure();
    if (!Objects.areEqual(actualOnFailure, onFailure)) {
      failWithMessage(assertjErrorMessage, actual, onFailure, actualOnFailure);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
