package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerManifestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerManifestAssert assertThat(io.fabric8.kubernetes.api.model.ContainerManifest actual) {
    return new io.fabric8.kubernetes.api.model.ContainerManifestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDir actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDisk actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoAssert assertThat(io.fabric8.kubernetes.api.model.GitRepo actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostDirAssert assertThat(io.fabric8.kubernetes.api.model.HostDir actual) {
    return new io.fabric8.kubernetes.api.model.HostDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LivenessProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LivenessProbeAssert assertThat(io.fabric8.kubernetes.api.model.LivenessProbe actual) {
    return new io.fabric8.kubernetes.api.model.LivenessProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionAssert assertThat(io.fabric8.kubernetes.api.model.Minion actual) {
    return new io.fabric8.kubernetes.api.model.MinionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MinionListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MinionListAssert assertThat(io.fabric8.kubernetes.api.model.MinionList actual) {
    return new io.fabric8.kubernetes.api.model.MinionListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeResourcesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeResourcesAssert assertThat(io.fabric8.kubernetes.api.model.NodeResources actual) {
    return new io.fabric8.kubernetes.api.model.NodeResourcesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStateAssert assertThat(io.fabric8.kubernetes.api.model.PodState actual) {
    return new io.fabric8.kubernetes.api.model.PodStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplate actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PortAssert assertThat(io.fabric8.kubernetes.api.model.Port actual) {
    return new io.fabric8.kubernetes.api.model.PortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerState actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicy actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyAlways actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyAlwaysAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyNever actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyNeverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert assertThat(io.fabric8.kubernetes.api.model.RestartPolicyOnFailure actual) {
    return new io.fabric8.kubernetes.api.model.RestartPolicyOnFailureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.VolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.VolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.base.Container actual) {
    return new io.fabric8.kubernetes.api.model.base.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.EmptyDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.EmptyDirAssert assertThat(io.fabric8.kubernetes.api.model.base.EmptyDir actual) {
    return new io.fabric8.kubernetes.api.model.base.EmptyDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.base.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.base.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.base.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.base.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.GCEPersistentDiskAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.GCEPersistentDiskAssert assertThat(io.fabric8.kubernetes.api.model.base.GCEPersistentDisk actual) {
    return new io.fabric8.kubernetes.api.model.base.GCEPersistentDiskAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.GitRepoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.GitRepoAssert assertThat(io.fabric8.kubernetes.api.model.base.GitRepo actual) {
    return new io.fabric8.kubernetes.api.model.base.GitRepoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.base.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.base.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.base.Handler actual) {
    return new io.fabric8.kubernetes.api.model.base.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.HostDirAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.HostDirAssert assertThat(io.fabric8.kubernetes.api.model.base.HostDir actual) {
    return new io.fabric8.kubernetes.api.model.base.HostDirAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.base.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.base.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.LivenessProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.LivenessProbeAssert assertThat(io.fabric8.kubernetes.api.model.base.LivenessProbe actual) {
    return new io.fabric8.kubernetes.api.model.base.LivenessProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.base.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.base.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.base.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.base.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.base.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.base.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.PortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.PortAssert assertThat(io.fabric8.kubernetes.api.model.base.Port actual) {
    return new io.fabric8.kubernetes.api.model.base.PortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.base.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.base.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicy actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyAlwaysAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyAlwaysAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicyAlways actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyAlwaysAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyNeverAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyNeverAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicyNever actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyNeverAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailureAssert assertThat(io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailure actual) {
    return new io.fabric8.kubernetes.api.model.base.RestartPolicyOnFailureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusAssert assertThat(io.fabric8.kubernetes.api.model.base.Status actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.base.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.base.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.base.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.base.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.base.Volume actual) {
    return new io.fabric8.kubernetes.api.model.base.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.base.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.base.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.base.VolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.base.VolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.base.VolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.base.VolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.errors.StatusErrorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.errors.StatusErrorAssert assertThat(io.fabric8.kubernetes.api.model.errors.StatusError actual) {
    return new io.fabric8.kubernetes.api.model.errors.StatusErrorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.resource.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.resource.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.resource.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.resource.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert assertThat(io.fabric8.kubernetes.api.model.runtime.RawExtension actual) {
    return new io.fabric8.kubernetes.api.model.runtime.RawExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.util.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.util.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.util.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.util.IntOrStringAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
