package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeStatusAssert<S extends AbstractNodeStatusAssert<S, A>, A extends NodeStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeStatusAssert}</code> to make assertions on actual NodeStatus.
   * @param actual the NodeStatus we want to make assertions on.
   */
  protected AbstractNodeStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus's conditions contains the given NodeCondition elements.
   * @param conditions the given elements that should be contained in actual NodeStatus's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's conditions does not contain all given NodeCondition elements.
   */
  public S hasConditions(NodeCondition... conditions) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) throw new AssertionError("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatus has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatus's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatus's phase is equal to the given one.
   * @param phase the given phase to compare the actual NodeStatus's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatus's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual NodeStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
