package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Handler} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHandlerAssert<S extends AbstractHandlerAssert<S, A>, A extends Handler> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHandlerAssert}</code> to make assertions on actual Handler.
   * @param actual the Handler we want to make assertions on.
   */
  protected AbstractHandlerAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Handler's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Handler's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Handler's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Handler's exec is equal to the given one.
   * @param exec the given exec to compare the actual Handler's exec to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Handler's exec is not equal to the given one.
   */
  public S hasExec(ExecAction exec) {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected exec of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ExecAction actualExec = actual.getExec();
    if (!Objects.areEqual(actualExec, exec)) {
      failWithMessage(assertjErrorMessage, actual, exec, actualExec);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Handler's httpGet is equal to the given one.
   * @param httpGet the given httpGet to compare the actual Handler's httpGet to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Handler's httpGet is not equal to the given one.
   */
  public S hasHttpGet(HTTPGetAction httpGet) {
    // check that actual Handler we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected httpGet of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HTTPGetAction actualHttpGet = actual.getHttpGet();
    if (!Objects.areEqual(actualHttpGet, httpGet)) {
      failWithMessage(assertjErrorMessage, actual, httpGet, actualHttpGet);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
