package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStateWaiting} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateWaitingAssert<S extends AbstractContainerStateWaitingAssert<S, A>, A extends ContainerStateWaiting> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateWaitingAssert}</code> to make assertions on actual ContainerStateWaiting.
   * @param actual the ContainerStateWaiting we want to make assertions on.
   */
  protected AbstractContainerStateWaitingAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStateWaiting's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStateWaiting's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateWaiting's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStateWaiting we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateWaiting's reason is equal to the given one.
   * @param reason the given reason to compare the actual ContainerStateWaiting's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateWaiting's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual ContainerStateWaiting we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
