package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Status} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatusAssert<S extends AbstractStatusAssert<S, A>, A extends Status> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatusAssert}</code> to make assertions on actual Status.
   * @param actual the Status we want to make assertions on.
   */
  protected AbstractStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Status's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Status's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual Status's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's code is equal to the given one.
   * @param code the given code to compare the actual Status's code to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's code is not equal to the given one.
   */
  public S hasCode(Integer code) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected code of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCode = actual.getCode();
    if (!Objects.areEqual(actualCode, code)) {
      failWithMessage(assertjErrorMessage, actual, code, actualCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's details is equal to the given one.
   * @param details the given details to compare the actual Status's details to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's details is not equal to the given one.
   */
  public S hasDetails(StatusDetails details) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected details of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    StatusDetails actualDetails = actual.getDetails();
    if (!Objects.areEqual(actualDetails, details)) {
      failWithMessage(assertjErrorMessage, actual, details, actualDetails);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's kind is equal to the given one.
   * @param kind the given kind to compare the actual Status's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's message is equal to the given one.
   * @param message the given message to compare the actual Status's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's reason is equal to the given one.
   * @param reason the given reason to compare the actual Status's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's resourceVersion is equal to the given one.
   * @param resourceVersion the given resourceVersion to compare the actual Status's resourceVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's resourceVersion is not equal to the given one.
   */
  public S hasResourceVersion(String resourceVersion) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceVersion = actual.getResourceVersion();
    if (!Objects.areEqual(actualResourceVersion, resourceVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceVersion, actualResourceVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's selfLink is equal to the given one.
   * @param selfLink the given selfLink to compare the actual Status's selfLink to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's selfLink is not equal to the given one.
   */
  public S hasSelfLink(String selfLink) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSelfLink = actual.getSelfLink();
    if (!Objects.areEqual(actualSelfLink, selfLink)) {
      failWithMessage(assertjErrorMessage, actual, selfLink, actualSelfLink);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Status's status is equal to the given one.
   * @param status the given status to compare the actual Status's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Status's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual Status we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
